// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A rule that controls access to mobile devices for an WorkMail group.
 */
public class MobileDeviceAccessRule private constructor(builder: Builder) {
    /**
     * The date and time at which an access rule was created.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The date and time at which an access rule was modified.
     */
    public val dateModified: aws.smithy.kotlin.runtime.time.Instant? = builder.dateModified
    /**
     * The description of a mobile access rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Device models that a rule will match.
     */
    public val deviceModels: List<String>? = builder.deviceModels
    /**
     * Device operating systems that a rule will match.
     */
    public val deviceOperatingSystems: List<String>? = builder.deviceOperatingSystems
    /**
     * Device types that a rule will match.
     */
    public val deviceTypes: List<String>? = builder.deviceTypes
    /**
     * Device user agents that a rule will match.
     */
    public val deviceUserAgents: List<String>? = builder.deviceUserAgents
    /**
     * The effect of the rule when it matches. Allowed values are `ALLOW` or `DENY`.
     */
    public val effect: aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRuleEffect? = builder.effect
    /**
     * The ID assigned to a mobile access rule.
     */
    public val mobileDeviceAccessRuleId: kotlin.String? = builder.mobileDeviceAccessRuleId
    /**
     * The name of a mobile access rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Device models that a rule **will not** match. All other device models will match.
     */
    public val notDeviceModels: List<String>? = builder.notDeviceModels
    /**
     * Device operating systems that a rule **will not** match. All other device types will match.
     */
    public val notDeviceOperatingSystems: List<String>? = builder.notDeviceOperatingSystems
    /**
     * Device types that a rule **will not** match. All other device types will match.
     */
    public val notDeviceTypes: List<String>? = builder.notDeviceTypes
    /**
     * Device user agents that a rule **will not** match. All other device user agents will match.
     */
    public val notDeviceUserAgents: List<String>? = builder.notDeviceUserAgents

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MobileDeviceAccessRule(")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("description=$description,")
        append("deviceModels=$deviceModels,")
        append("deviceOperatingSystems=$deviceOperatingSystems,")
        append("deviceTypes=$deviceTypes,")
        append("deviceUserAgents=$deviceUserAgents,")
        append("effect=$effect,")
        append("mobileDeviceAccessRuleId=$mobileDeviceAccessRuleId,")
        append("name=$name,")
        append("notDeviceModels=$notDeviceModels,")
        append("notDeviceOperatingSystems=$notDeviceOperatingSystems,")
        append("notDeviceTypes=$notDeviceTypes,")
        append("notDeviceUserAgents=$notDeviceUserAgents")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateCreated?.hashCode() ?: 0
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceModels?.hashCode() ?: 0)
        result = 31 * result + (deviceOperatingSystems?.hashCode() ?: 0)
        result = 31 * result + (deviceTypes?.hashCode() ?: 0)
        result = 31 * result + (deviceUserAgents?.hashCode() ?: 0)
        result = 31 * result + (effect?.hashCode() ?: 0)
        result = 31 * result + (mobileDeviceAccessRuleId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notDeviceModels?.hashCode() ?: 0)
        result = 31 * result + (notDeviceOperatingSystems?.hashCode() ?: 0)
        result = 31 * result + (notDeviceTypes?.hashCode() ?: 0)
        result = 31 * result + (notDeviceUserAgents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MobileDeviceAccessRule

        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (description != other.description) return false
        if (deviceModels != other.deviceModels) return false
        if (deviceOperatingSystems != other.deviceOperatingSystems) return false
        if (deviceTypes != other.deviceTypes) return false
        if (deviceUserAgents != other.deviceUserAgents) return false
        if (effect != other.effect) return false
        if (mobileDeviceAccessRuleId != other.mobileDeviceAccessRuleId) return false
        if (name != other.name) return false
        if (notDeviceModels != other.notDeviceModels) return false
        if (notDeviceOperatingSystems != other.notDeviceOperatingSystems) return false
        if (notDeviceTypes != other.notDeviceTypes) return false
        if (notDeviceUserAgents != other.notDeviceUserAgents) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time at which an access rule was created.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time at which an access rule was modified.
         */
        public var dateModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of a mobile access rule.
         */
        public var description: kotlin.String? = null
        /**
         * Device models that a rule will match.
         */
        public var deviceModels: List<String>? = null
        /**
         * Device operating systems that a rule will match.
         */
        public var deviceOperatingSystems: List<String>? = null
        /**
         * Device types that a rule will match.
         */
        public var deviceTypes: List<String>? = null
        /**
         * Device user agents that a rule will match.
         */
        public var deviceUserAgents: List<String>? = null
        /**
         * The effect of the rule when it matches. Allowed values are `ALLOW` or `DENY`.
         */
        public var effect: aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRuleEffect? = null
        /**
         * The ID assigned to a mobile access rule.
         */
        public var mobileDeviceAccessRuleId: kotlin.String? = null
        /**
         * The name of a mobile access rule.
         */
        public var name: kotlin.String? = null
        /**
         * Device models that a rule **will not** match. All other device models will match.
         */
        public var notDeviceModels: List<String>? = null
        /**
         * Device operating systems that a rule **will not** match. All other device types will match.
         */
        public var notDeviceOperatingSystems: List<String>? = null
        /**
         * Device types that a rule **will not** match. All other device types will match.
         */
        public var notDeviceTypes: List<String>? = null
        /**
         * Device user agents that a rule **will not** match. All other device user agents will match.
         */
        public var notDeviceUserAgents: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRule) : this() {
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.description = x.description
            this.deviceModels = x.deviceModels
            this.deviceOperatingSystems = x.deviceOperatingSystems
            this.deviceTypes = x.deviceTypes
            this.deviceUserAgents = x.deviceUserAgents
            this.effect = x.effect
            this.mobileDeviceAccessRuleId = x.mobileDeviceAccessRuleId
            this.name = x.name
            this.notDeviceModels = x.notDeviceModels
            this.notDeviceOperatingSystems = x.notDeviceOperatingSystems
            this.notDeviceTypes = x.notDeviceTypes
            this.notDeviceUserAgents = x.notDeviceUserAgents
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRule = MobileDeviceAccessRule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
