// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a mailbox export job, including the user or resource ID associated with the mailbox and the S3 bucket that the mailbox contents are exported to.
 */
public class MailboxExportJob private constructor(builder: Builder) {
    /**
     * The mailbox export job description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The mailbox export job end timestamp.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The identifier of the user or resource associated with the mailbox.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The estimated progress of the mailbox export job, in percentage points.
     */
    public val estimatedProgress: kotlin.Int = builder.estimatedProgress
    /**
     * The identifier of the mailbox export job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The name of the S3 bucket.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The path to the S3 bucket and file that the mailbox export job exports to.
     */
    public val s3Path: kotlin.String? = builder.s3Path
    /**
     * The mailbox export job start timestamp.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the mailbox export job.
     */
    public val state: aws.sdk.kotlin.services.workmail.model.MailboxExportJobState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.MailboxExportJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MailboxExportJob(")
        append("description=$description,")
        append("endTime=$endTime,")
        append("entityId=$entityId,")
        append("estimatedProgress=$estimatedProgress,")
        append("jobId=$jobId,")
        append("s3BucketName=$s3BucketName,")
        append("s3Path=$s3Path,")
        append("startTime=$startTime,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (estimatedProgress)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3Path?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MailboxExportJob

        if (description != other.description) return false
        if (endTime != other.endTime) return false
        if (entityId != other.entityId) return false
        if (estimatedProgress != other.estimatedProgress) return false
        if (jobId != other.jobId) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3Path != other.s3Path) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.MailboxExportJob = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The mailbox export job description.
         */
        public var description: kotlin.String? = null
        /**
         * The mailbox export job end timestamp.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the user or resource associated with the mailbox.
         */
        public var entityId: kotlin.String? = null
        /**
         * The estimated progress of the mailbox export job, in percentage points.
         */
        public var estimatedProgress: kotlin.Int = 0
        /**
         * The identifier of the mailbox export job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The name of the S3 bucket.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The path to the S3 bucket and file that the mailbox export job exports to.
         */
        public var s3Path: kotlin.String? = null
        /**
         * The mailbox export job start timestamp.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the mailbox export job.
         */
        public var state: aws.sdk.kotlin.services.workmail.model.MailboxExportJobState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.MailboxExportJob) : this() {
            this.description = x.description
            this.endTime = x.endTime
            this.entityId = x.entityId
            this.estimatedProgress = x.estimatedProgress
            this.jobId = x.jobId
            this.s3BucketName = x.s3BucketName
            this.s3Path = x.s3Path
            this.startTime = x.startTime
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.MailboxExportJob = MailboxExportJob(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
