// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListGroupMembersRequest private constructor(builder: Builder) {
    /**
     * The identifier for the group to which the members (users or groups) are associated.
     *
     * The identifier can accept *GroupId*, *Groupname*, or *email*. The following identity formats are available:
     * + Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * + Email address: group@domain.tld
     * + Group name: group
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The maximum number of results to return in a single call.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results. The first call does not contain any tokens.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier for the organization under which the group exists.
     */
    public val organizationId: kotlin.String? = builder.organizationId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.ListGroupMembersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGroupMembersRequest(")
        append("groupId=$groupId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("organizationId=$organizationId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGroupMembersRequest

        if (groupId != other.groupId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (organizationId != other.organizationId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.ListGroupMembersRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the group to which the members (users or groups) are associated.
         *
         * The identifier can accept *GroupId*, *Groupname*, or *email*. The following identity formats are available:
         * + Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
         * + Email address: group@domain.tld
         * + Group name: group
         */
        public var groupId: kotlin.String? = null
        /**
         * The maximum number of results to return in a single call.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to use to retrieve the next page of results. The first call does not contain any tokens.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier for the organization under which the group exists.
         */
        public var organizationId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.ListGroupMembersRequest) : this() {
            this.groupId = x.groupId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.organizationId = x.organizationId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.ListGroupMembersRequest = ListGroupMembersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
