// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.DescribeOrganizationResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeOrganizationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeOrganizationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeOrganizationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationError(context, call, payload)
        }
        val builder = DescribeOrganizationResponse.Builder()

        if (payload != null) {
            deserializeDescribeOrganizationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeOrganizationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrganizationOperationBody(builder: DescribeOrganizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ARN"))
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Alias"))
    val COMPLETEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletedDate"))
    val DEFAULTMAILDOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultMailDomain"))
    val DIRECTORYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryId"))
    val DIRECTORYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryType"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val INTEROPERABILITYENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("InteroperabilityEnabled"))
    val MIGRATIONADMIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MigrationAdmin"))
    val ORGANIZATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrganizationId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ALIAS_DESCRIPTOR)
        field(COMPLETEDDATE_DESCRIPTOR)
        field(DEFAULTMAILDOMAIN_DESCRIPTOR)
        field(DIRECTORYID_DESCRIPTOR)
        field(DIRECTORYTYPE_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(INTEROPERABILITYENABLED_DESCRIPTOR)
        field(MIGRATIONADMIN_DESCRIPTOR)
        field(ORGANIZATIONID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeString()
                COMPLETEDDATE_DESCRIPTOR.index -> builder.completedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEFAULTMAILDOMAIN_DESCRIPTOR.index -> builder.defaultMailDomain = deserializeString()
                DIRECTORYID_DESCRIPTOR.index -> builder.directoryId = deserializeString()
                DIRECTORYTYPE_DESCRIPTOR.index -> builder.directoryType = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                INTEROPERABILITYENABLED_DESCRIPTOR.index -> builder.interoperabilityEnabled = deserializeBoolean()
                MIGRATIONADMIN_DESCRIPTOR.index -> builder.migrationAdmin = deserializeString()
                ORGANIZATIONID_DESCRIPTOR.index -> builder.organizationId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
