// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Permission granted to a user, group, or resource to access a certain aspect of another user, group, or resource mailbox.
 */
public class Permission private constructor(builder: Builder) {
    /**
     * The identifier of the user, group, or resource to which the permissions are granted.
     */
    public val granteeId: kotlin.String = requireNotNull(builder.granteeId) { "A non-null value must be provided for granteeId" }
    /**
     * The type of user, group, or resource referred to in GranteeId.
     */
    public val granteeType: aws.sdk.kotlin.services.workmail.model.MemberType = requireNotNull(builder.granteeType) { "A non-null value must be provided for granteeType" }
    /**
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     */
    public val permissionValues: List<PermissionType> = requireNotNull(builder.permissionValues) { "A non-null value must be provided for permissionValues" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.Permission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Permission(")
        append("granteeId=$granteeId,")
        append("granteeType=$granteeType,")
        append("permissionValues=$permissionValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = granteeId.hashCode()
        result = 31 * result + (granteeType.hashCode())
        result = 31 * result + (permissionValues.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Permission

        if (granteeId != other.granteeId) return false
        if (granteeType != other.granteeType) return false
        if (permissionValues != other.permissionValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.Permission = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the user, group, or resource to which the permissions are granted.
         */
        public var granteeId: kotlin.String? = null
        /**
         * The type of user, group, or resource referred to in GranteeId.
         */
        public var granteeType: aws.sdk.kotlin.services.workmail.model.MemberType? = null
        /**
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
         */
        public var permissionValues: List<PermissionType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.Permission) : this() {
            this.granteeId = x.granteeId
            this.granteeType = x.granteeType
            this.permissionValues = x.permissionValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.Permission = Permission(this)

        internal fun correctErrors(): Builder {
            if (granteeId == null) granteeId = ""
            if (granteeType == null) granteeType = MemberType.SdkUnknown("no value provided")
            if (permissionValues == null) permissionValues = emptyList()
            return this
        }
    }
}
