// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.workmail.auth.DefaultWorkMailAuthSchemeProvider
import aws.sdk.kotlin.services.workmail.auth.WorkMailAuthSchemeProvider
import aws.sdk.kotlin.services.workmail.endpoints.DefaultWorkMailEndpointProvider
import aws.sdk.kotlin.services.workmail.endpoints.WorkMailEndpointParameters
import aws.sdk.kotlin.services.workmail.endpoints.WorkMailEndpointProvider
import aws.sdk.kotlin.services.workmail.model.AssociateDelegateToResourceRequest
import aws.sdk.kotlin.services.workmail.model.AssociateDelegateToResourceResponse
import aws.sdk.kotlin.services.workmail.model.AssociateMemberToGroupRequest
import aws.sdk.kotlin.services.workmail.model.AssociateMemberToGroupResponse
import aws.sdk.kotlin.services.workmail.model.AssumeImpersonationRoleRequest
import aws.sdk.kotlin.services.workmail.model.AssumeImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.CancelMailboxExportJobRequest
import aws.sdk.kotlin.services.workmail.model.CancelMailboxExportJobResponse
import aws.sdk.kotlin.services.workmail.model.CreateAliasRequest
import aws.sdk.kotlin.services.workmail.model.CreateAliasResponse
import aws.sdk.kotlin.services.workmail.model.CreateAvailabilityConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.CreateAvailabilityConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.CreateGroupRequest
import aws.sdk.kotlin.services.workmail.model.CreateGroupResponse
import aws.sdk.kotlin.services.workmail.model.CreateIdentityCenterApplicationRequest
import aws.sdk.kotlin.services.workmail.model.CreateIdentityCenterApplicationResponse
import aws.sdk.kotlin.services.workmail.model.CreateImpersonationRoleRequest
import aws.sdk.kotlin.services.workmail.model.CreateImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.CreateMobileDeviceAccessRuleRequest
import aws.sdk.kotlin.services.workmail.model.CreateMobileDeviceAccessRuleResponse
import aws.sdk.kotlin.services.workmail.model.CreateOrganizationRequest
import aws.sdk.kotlin.services.workmail.model.CreateOrganizationResponse
import aws.sdk.kotlin.services.workmail.model.CreateResourceRequest
import aws.sdk.kotlin.services.workmail.model.CreateResourceResponse
import aws.sdk.kotlin.services.workmail.model.CreateUserRequest
import aws.sdk.kotlin.services.workmail.model.CreateUserResponse
import aws.sdk.kotlin.services.workmail.model.DeleteAccessControlRuleRequest
import aws.sdk.kotlin.services.workmail.model.DeleteAccessControlRuleResponse
import aws.sdk.kotlin.services.workmail.model.DeleteAliasRequest
import aws.sdk.kotlin.services.workmail.model.DeleteAliasResponse
import aws.sdk.kotlin.services.workmail.model.DeleteAvailabilityConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.DeleteAvailabilityConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.DeleteEmailMonitoringConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.DeleteEmailMonitoringConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.DeleteGroupRequest
import aws.sdk.kotlin.services.workmail.model.DeleteGroupResponse
import aws.sdk.kotlin.services.workmail.model.DeleteIdentityCenterApplicationRequest
import aws.sdk.kotlin.services.workmail.model.DeleteIdentityCenterApplicationResponse
import aws.sdk.kotlin.services.workmail.model.DeleteIdentityProviderConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.DeleteIdentityProviderConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.DeleteImpersonationRoleRequest
import aws.sdk.kotlin.services.workmail.model.DeleteImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.DeleteMailboxPermissionsRequest
import aws.sdk.kotlin.services.workmail.model.DeleteMailboxPermissionsResponse
import aws.sdk.kotlin.services.workmail.model.DeleteMobileDeviceAccessOverrideRequest
import aws.sdk.kotlin.services.workmail.model.DeleteMobileDeviceAccessOverrideResponse
import aws.sdk.kotlin.services.workmail.model.DeleteMobileDeviceAccessRuleRequest
import aws.sdk.kotlin.services.workmail.model.DeleteMobileDeviceAccessRuleResponse
import aws.sdk.kotlin.services.workmail.model.DeleteOrganizationRequest
import aws.sdk.kotlin.services.workmail.model.DeleteOrganizationResponse
import aws.sdk.kotlin.services.workmail.model.DeletePersonalAccessTokenRequest
import aws.sdk.kotlin.services.workmail.model.DeletePersonalAccessTokenResponse
import aws.sdk.kotlin.services.workmail.model.DeleteResourceRequest
import aws.sdk.kotlin.services.workmail.model.DeleteResourceResponse
import aws.sdk.kotlin.services.workmail.model.DeleteRetentionPolicyRequest
import aws.sdk.kotlin.services.workmail.model.DeleteRetentionPolicyResponse
import aws.sdk.kotlin.services.workmail.model.DeleteUserRequest
import aws.sdk.kotlin.services.workmail.model.DeleteUserResponse
import aws.sdk.kotlin.services.workmail.model.DeregisterFromWorkMailRequest
import aws.sdk.kotlin.services.workmail.model.DeregisterFromWorkMailResponse
import aws.sdk.kotlin.services.workmail.model.DeregisterMailDomainRequest
import aws.sdk.kotlin.services.workmail.model.DeregisterMailDomainResponse
import aws.sdk.kotlin.services.workmail.model.DescribeEmailMonitoringConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.DescribeEmailMonitoringConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.DescribeEntityRequest
import aws.sdk.kotlin.services.workmail.model.DescribeEntityResponse
import aws.sdk.kotlin.services.workmail.model.DescribeGroupRequest
import aws.sdk.kotlin.services.workmail.model.DescribeGroupResponse
import aws.sdk.kotlin.services.workmail.model.DescribeIdentityProviderConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.DescribeIdentityProviderConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.DescribeInboundDmarcSettingsRequest
import aws.sdk.kotlin.services.workmail.model.DescribeInboundDmarcSettingsResponse
import aws.sdk.kotlin.services.workmail.model.DescribeMailboxExportJobRequest
import aws.sdk.kotlin.services.workmail.model.DescribeMailboxExportJobResponse
import aws.sdk.kotlin.services.workmail.model.DescribeOrganizationRequest
import aws.sdk.kotlin.services.workmail.model.DescribeOrganizationResponse
import aws.sdk.kotlin.services.workmail.model.DescribeResourceRequest
import aws.sdk.kotlin.services.workmail.model.DescribeResourceResponse
import aws.sdk.kotlin.services.workmail.model.DescribeUserRequest
import aws.sdk.kotlin.services.workmail.model.DescribeUserResponse
import aws.sdk.kotlin.services.workmail.model.DisassociateDelegateFromResourceRequest
import aws.sdk.kotlin.services.workmail.model.DisassociateDelegateFromResourceResponse
import aws.sdk.kotlin.services.workmail.model.DisassociateMemberFromGroupRequest
import aws.sdk.kotlin.services.workmail.model.DisassociateMemberFromGroupResponse
import aws.sdk.kotlin.services.workmail.model.GetAccessControlEffectRequest
import aws.sdk.kotlin.services.workmail.model.GetAccessControlEffectResponse
import aws.sdk.kotlin.services.workmail.model.GetDefaultRetentionPolicyRequest
import aws.sdk.kotlin.services.workmail.model.GetDefaultRetentionPolicyResponse
import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleEffectRequest
import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleEffectResponse
import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleRequest
import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.GetMailDomainRequest
import aws.sdk.kotlin.services.workmail.model.GetMailDomainResponse
import aws.sdk.kotlin.services.workmail.model.GetMailboxDetailsRequest
import aws.sdk.kotlin.services.workmail.model.GetMailboxDetailsResponse
import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessEffectRequest
import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessEffectResponse
import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessOverrideRequest
import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessOverrideResponse
import aws.sdk.kotlin.services.workmail.model.GetPersonalAccessTokenMetadataRequest
import aws.sdk.kotlin.services.workmail.model.GetPersonalAccessTokenMetadataResponse
import aws.sdk.kotlin.services.workmail.model.ListAccessControlRulesRequest
import aws.sdk.kotlin.services.workmail.model.ListAccessControlRulesResponse
import aws.sdk.kotlin.services.workmail.model.ListAliasesRequest
import aws.sdk.kotlin.services.workmail.model.ListAliasesResponse
import aws.sdk.kotlin.services.workmail.model.ListAvailabilityConfigurationsRequest
import aws.sdk.kotlin.services.workmail.model.ListAvailabilityConfigurationsResponse
import aws.sdk.kotlin.services.workmail.model.ListGroupMembersRequest
import aws.sdk.kotlin.services.workmail.model.ListGroupMembersResponse
import aws.sdk.kotlin.services.workmail.model.ListGroupsForEntityRequest
import aws.sdk.kotlin.services.workmail.model.ListGroupsForEntityResponse
import aws.sdk.kotlin.services.workmail.model.ListGroupsRequest
import aws.sdk.kotlin.services.workmail.model.ListGroupsResponse
import aws.sdk.kotlin.services.workmail.model.ListImpersonationRolesRequest
import aws.sdk.kotlin.services.workmail.model.ListImpersonationRolesResponse
import aws.sdk.kotlin.services.workmail.model.ListMailDomainsRequest
import aws.sdk.kotlin.services.workmail.model.ListMailDomainsResponse
import aws.sdk.kotlin.services.workmail.model.ListMailboxExportJobsRequest
import aws.sdk.kotlin.services.workmail.model.ListMailboxExportJobsResponse
import aws.sdk.kotlin.services.workmail.model.ListMailboxPermissionsRequest
import aws.sdk.kotlin.services.workmail.model.ListMailboxPermissionsResponse
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessOverridesRequest
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessOverridesResponse
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessRulesRequest
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessRulesResponse
import aws.sdk.kotlin.services.workmail.model.ListOrganizationsRequest
import aws.sdk.kotlin.services.workmail.model.ListOrganizationsResponse
import aws.sdk.kotlin.services.workmail.model.ListPersonalAccessTokensRequest
import aws.sdk.kotlin.services.workmail.model.ListPersonalAccessTokensResponse
import aws.sdk.kotlin.services.workmail.model.ListResourceDelegatesRequest
import aws.sdk.kotlin.services.workmail.model.ListResourceDelegatesResponse
import aws.sdk.kotlin.services.workmail.model.ListResourcesRequest
import aws.sdk.kotlin.services.workmail.model.ListResourcesResponse
import aws.sdk.kotlin.services.workmail.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.workmail.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.workmail.model.ListUsersRequest
import aws.sdk.kotlin.services.workmail.model.ListUsersResponse
import aws.sdk.kotlin.services.workmail.model.PutAccessControlRuleRequest
import aws.sdk.kotlin.services.workmail.model.PutAccessControlRuleResponse
import aws.sdk.kotlin.services.workmail.model.PutEmailMonitoringConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.PutEmailMonitoringConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.PutIdentityProviderConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.PutIdentityProviderConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.PutInboundDmarcSettingsRequest
import aws.sdk.kotlin.services.workmail.model.PutInboundDmarcSettingsResponse
import aws.sdk.kotlin.services.workmail.model.PutMailboxPermissionsRequest
import aws.sdk.kotlin.services.workmail.model.PutMailboxPermissionsResponse
import aws.sdk.kotlin.services.workmail.model.PutMobileDeviceAccessOverrideRequest
import aws.sdk.kotlin.services.workmail.model.PutMobileDeviceAccessOverrideResponse
import aws.sdk.kotlin.services.workmail.model.PutRetentionPolicyRequest
import aws.sdk.kotlin.services.workmail.model.PutRetentionPolicyResponse
import aws.sdk.kotlin.services.workmail.model.RegisterMailDomainRequest
import aws.sdk.kotlin.services.workmail.model.RegisterMailDomainResponse
import aws.sdk.kotlin.services.workmail.model.RegisterToWorkMailRequest
import aws.sdk.kotlin.services.workmail.model.RegisterToWorkMailResponse
import aws.sdk.kotlin.services.workmail.model.ResetPasswordRequest
import aws.sdk.kotlin.services.workmail.model.ResetPasswordResponse
import aws.sdk.kotlin.services.workmail.model.StartMailboxExportJobRequest
import aws.sdk.kotlin.services.workmail.model.StartMailboxExportJobResponse
import aws.sdk.kotlin.services.workmail.model.TagResourceRequest
import aws.sdk.kotlin.services.workmail.model.TagResourceResponse
import aws.sdk.kotlin.services.workmail.model.TestAvailabilityConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.TestAvailabilityConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.UntagResourceRequest
import aws.sdk.kotlin.services.workmail.model.UntagResourceResponse
import aws.sdk.kotlin.services.workmail.model.UpdateAvailabilityConfigurationRequest
import aws.sdk.kotlin.services.workmail.model.UpdateAvailabilityConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.UpdateDefaultMailDomainRequest
import aws.sdk.kotlin.services.workmail.model.UpdateDefaultMailDomainResponse
import aws.sdk.kotlin.services.workmail.model.UpdateGroupRequest
import aws.sdk.kotlin.services.workmail.model.UpdateGroupResponse
import aws.sdk.kotlin.services.workmail.model.UpdateImpersonationRoleRequest
import aws.sdk.kotlin.services.workmail.model.UpdateImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.UpdateMailboxQuotaRequest
import aws.sdk.kotlin.services.workmail.model.UpdateMailboxQuotaResponse
import aws.sdk.kotlin.services.workmail.model.UpdateMobileDeviceAccessRuleRequest
import aws.sdk.kotlin.services.workmail.model.UpdateMobileDeviceAccessRuleResponse
import aws.sdk.kotlin.services.workmail.model.UpdatePrimaryEmailAddressRequest
import aws.sdk.kotlin.services.workmail.model.UpdatePrimaryEmailAddressResponse
import aws.sdk.kotlin.services.workmail.model.UpdateResourceRequest
import aws.sdk.kotlin.services.workmail.model.UpdateResourceResponse
import aws.sdk.kotlin.services.workmail.model.UpdateUserRequest
import aws.sdk.kotlin.services.workmail.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "WorkMail"
public const val SdkVersion: String = "1.3.93"
public const val ServiceApiVersion: String = "2017-10-01"

/**
 * WorkMail is a secure, managed business email and calendaring service with support for existing desktop and mobile email clients. You can access your email, contacts, and calendars using Microsoft Outlook, your browser, or other native iOS and Android email applications. You can integrate WorkMail with your existing corporate directory and control both the keys that encrypt your data and the location in which your data is stored.
 *
 * The WorkMail API is designed for the following scenarios:
 * + Listing and describing organizations
 *
 * + Managing users
 *
 * + Managing groups
 *
 * + Managing resources
 *
 * All WorkMail API operations are Amazon-authenticated and certificate-signed. They not only require the use of the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help facilitate access, trust, and permission policies. By creating a role and allowing an IAM user to access the WorkMail site, the IAM user gains full administrative visibility into the entire WorkMail organization (or as set in the IAM policy). This includes, but is not limited to, the ability to create, update, and delete users, groups, and resources. This allows developers to perform the scenarios listed above, as well as give users the ability to grant access on a selective basis using the IAM model.
 */
public interface WorkMailClient : SdkClient {
    /**
     * WorkMailClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WorkMailClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "WorkMail",
                "WORKMAIL",
                "workmail",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WorkMailClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WorkMailClient = DefaultWorkMailClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: WorkMailEndpointProvider = builder.endpointProvider ?: DefaultWorkMailEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: WorkMailAuthSchemeProvider = builder.authSchemeProvider ?: DefaultWorkMailAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WorkMail"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: WorkMailEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: WorkMailAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a member (user or group) to the resource's set of delegates.
     */
    public suspend fun associateDelegateToResource(input: AssociateDelegateToResourceRequest): AssociateDelegateToResourceResponse

    /**
     * Adds a member (user or group) to the group's set.
     */
    public suspend fun associateMemberToGroup(input: AssociateMemberToGroupRequest): AssociateMemberToGroupResponse

    /**
     * Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token you can use to make impersonated calls.
     */
    public suspend fun assumeImpersonationRole(input: AssumeImpersonationRoleRequest): AssumeImpersonationRoleResponse

    /**
     * Cancels a mailbox export job.
     *
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     */
    public suspend fun cancelMailboxExportJob(input: CancelMailboxExportJobRequest): CancelMailboxExportJobResponse

    /**
     * Adds an alias to the set of a given member (user or group) of WorkMail.
     */
    public suspend fun createAlias(input: CreateAliasRequest): CreateAliasResponse

    /**
     * Creates an `AvailabilityConfiguration` for the given WorkMail organization and domain.
     */
    public suspend fun createAvailabilityConfiguration(input: CreateAvailabilityConfigurationRequest): CreateAvailabilityConfigurationResponse

    /**
     * Creates a group that can be used in WorkMail by calling the RegisterToWorkMail operation.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates the WorkMail application in IAM Identity Center that can be used later in the WorkMail - IdC integration. For more information, see PutIdentityProviderConfiguration. This action does not affect the authentication settings for any WorkMail organizations.
     */
    public suspend fun createIdentityCenterApplication(input: CreateIdentityCenterApplicationRequest): CreateIdentityCenterApplicationResponse

    /**
     * Creates an impersonation role for the given WorkMail organization.
     *
     * *Idempotency* ensures that an API request completes no more than one time. With an idempotent request, if the original request completes successfully, any subsequent retries also complete successfully without performing any further actions.
     */
    public suspend fun createImpersonationRole(input: CreateImpersonationRoleRequest): CreateImpersonationRoleResponse

    /**
     * Creates a new mobile device access rule for the specified WorkMail organization.
     */
    public suspend fun createMobileDeviceAccessRule(input: CreateMobileDeviceAccessRuleRequest): CreateMobileDeviceAccessRuleResponse

    /**
     * Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new WorkMail directory for you. For more information, see [Adding an organization](https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html) in the *WorkMail Administrator Guide*.
     *
     * You can associate multiple email domains with an organization, then choose your default email domain from the WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see [Adding a domain](https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html) and [Choosing the default domain](https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html) in the *WorkMail Administrator Guide*.
     *
     * Optionally, you can use a customer managed key from AWS Key Management Service (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, WorkMail creates a default, AWS managed key for you.
     */
    public suspend fun createOrganization(input: CreateOrganizationRequest): CreateOrganizationResponse

    /**
     * Creates a new WorkMail resource.
     */
    public suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse

    /**
     * Creates a user who can be used in WorkMail by calling the RegisterToWorkMail operation.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Deletes an access control rule for the specified WorkMail organization.
     *
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    public suspend fun deleteAccessControlRule(input: DeleteAccessControlRuleRequest): DeleteAccessControlRuleResponse

    /**
     * Remove one or more specified aliases from a set of aliases for a given user.
     */
    public suspend fun deleteAlias(input: DeleteAliasRequest): DeleteAliasResponse

    /**
     * Deletes the `AvailabilityConfiguration` for the given WorkMail organization and domain.
     */
    public suspend fun deleteAvailabilityConfiguration(input: DeleteAvailabilityConfigurationRequest): DeleteAvailabilityConfigurationResponse

    /**
     * Deletes the email monitoring configuration for a specified organization.
     */
    public suspend fun deleteEmailMonitoringConfiguration(input: DeleteEmailMonitoringConfigurationRequest): DeleteEmailMonitoringConfigurationResponse

    /**
     * Deletes a group from WorkMail.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes the IAM Identity Center application from WorkMail. This action does not affect the authentication settings for any WorkMail organizations.
     */
    public suspend fun deleteIdentityCenterApplication(input: DeleteIdentityCenterApplicationRequest): DeleteIdentityCenterApplicationResponse

    /**
     * Disables the integration between IdC and WorkMail. Authentication will continue with the directory as it was before the IdC integration. You might have to reset your directory passwords and reconfigure your desktop and mobile email clients.
     */
    public suspend fun deleteIdentityProviderConfiguration(input: DeleteIdentityProviderConfigurationRequest): DeleteIdentityProviderConfigurationResponse

    /**
     * Deletes an impersonation role for the given WorkMail organization.
     */
    public suspend fun deleteImpersonationRole(input: DeleteImpersonationRoleRequest): DeleteImpersonationRoleResponse

    /**
     * Deletes permissions granted to a member (user or group).
     */
    public suspend fun deleteMailboxPermissions(input: DeleteMailboxPermissionsRequest): DeleteMailboxPermissionsResponse

    /**
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     *
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    public suspend fun deleteMobileDeviceAccessOverride(input: DeleteMobileDeviceAccessOverrideRequest): DeleteMobileDeviceAccessOverrideResponse

    /**
     * Deletes a mobile device access rule for the specified WorkMail organization.
     *
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
     */
    public suspend fun deleteMobileDeviceAccessRule(input: DeleteMobileDeviceAccessRuleRequest): DeleteMobileDeviceAccessRuleResponse

    /**
     * Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see [Removing an organization](https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html) in the *WorkMail Administrator Guide*.
     */
    public suspend fun deleteOrganization(input: DeleteOrganizationRequest): DeleteOrganizationResponse

    /**
     * Deletes the Personal Access Token from the provided WorkMail Organization.
     */
    public suspend fun deletePersonalAccessToken(input: DeletePersonalAccessTokenRequest): DeletePersonalAccessTokenResponse

    /**
     * Deletes the specified resource.
     */
    public suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse

    /**
     * Deletes the specified retention policy from the specified organization.
     */
    public suspend fun deleteRetentionPolicy(input: DeleteRetentionPolicyRequest): DeleteRetentionPolicyResponse

    /**
     * Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be `DISABLED`. Use the DescribeUser action to confirm the user state.
     *
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are permanently removed.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is *Disable*.
     */
    public suspend fun deregisterFromWorkMail(input: DeregisterFromWorkMailRequest): DeregisterFromWorkMailResponse

    /**
     * Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address used by WorkMail entities before you remove the domain.
     */
    public suspend fun deregisterMailDomain(input: DeregisterMailDomainRequest): DeregisterMailDomainResponse

    /**
     * Describes the current email monitoring configuration for a specified organization.
     */
    public suspend fun describeEmailMonitoringConfiguration(input: DescribeEmailMonitoringConfigurationRequest): DescribeEmailMonitoringConfigurationResponse

    /**
     * Returns basic details about an entity in WorkMail.
     */
    public suspend fun describeEntity(input: DescribeEntityRequest): DescribeEntityResponse

    /**
     * Returns the data available for the group.
     */
    public suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse

    /**
     * Returns detailed information on the current IdC setup for the WorkMail organization.
     */
    public suspend fun describeIdentityProviderConfiguration(input: DescribeIdentityProviderConfigurationRequest): DescribeIdentityProviderConfigurationResponse

    /**
     * Lists the settings in a DMARC policy for a specified organization.
     */
    public suspend fun describeInboundDmarcSettings(input: DescribeInboundDmarcSettingsRequest): DescribeInboundDmarcSettingsResponse

    /**
     * Describes the current status of a mailbox export job.
     */
    public suspend fun describeMailboxExportJob(input: DescribeMailboxExportJobRequest): DescribeMailboxExportJobResponse

    /**
     * Provides more information regarding a given organization based on its identifier.
     */
    public suspend fun describeOrganization(input: DescribeOrganizationRequest): DescribeOrganizationResponse

    /**
     * Returns the data available for the resource.
     */
    public suspend fun describeResource(input: DescribeResourceRequest): DescribeResourceResponse

    /**
     * Provides information regarding the user.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Removes a member from the resource's set of delegates.
     */
    public suspend fun disassociateDelegateFromResource(input: DisassociateDelegateFromResourceRequest): DisassociateDelegateFromResourceResponse

    /**
     * Removes a member from a group.
     */
    public suspend fun disassociateMemberFromGroup(input: DisassociateMemberFromGroupRequest): DisassociateMemberFromGroupResponse

    /**
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role ID. Impersonation role ID can only be used with Action EWS.
     */
    public suspend fun getAccessControlEffect(input: GetAccessControlEffectRequest): GetAccessControlEffectResponse

    /**
     * Gets the default retention policy details for the specified organization.
     */
    public suspend fun getDefaultRetentionPolicy(input: GetDefaultRetentionPolicyRequest): GetDefaultRetentionPolicyResponse

    /**
     * Gets the impersonation role details for the given WorkMail organization.
     */
    public suspend fun getImpersonationRole(input: GetImpersonationRoleRequest): GetImpersonationRoleResponse

    /**
     * Tests whether the given impersonation role can impersonate a target user.
     */
    public suspend fun getImpersonationRoleEffect(input: GetImpersonationRoleEffectRequest): GetImpersonationRoleEffectResponse

    /**
     * Gets details for a mail domain, including domain records required to configure your domain with recommended security.
     */
    public suspend fun getMailDomain(input: GetMailDomainRequest): GetMailDomainResponse

    /**
     * Requests a user's mailbox details for a specified organization and user.
     */
    public suspend fun getMailboxDetails(input: GetMailboxDetailsRequest): GetMailboxDetailsResponse

    /**
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the WorkMail organization for a particular user's attributes.
     */
    public suspend fun getMobileDeviceAccessEffect(input: GetMobileDeviceAccessEffectRequest): GetMobileDeviceAccessEffectResponse

    /**
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     */
    public suspend fun getMobileDeviceAccessOverride(input: GetMobileDeviceAccessOverrideRequest): GetMobileDeviceAccessOverrideResponse

    /**
     * Requests details of a specific Personal Access Token within the WorkMail organization.
     */
    public suspend fun getPersonalAccessTokenMetadata(input: GetPersonalAccessTokenMetadataRequest): GetPersonalAccessTokenMetadataResponse

    /**
     * Lists the access control rules for the specified organization.
     */
    public suspend fun listAccessControlRules(input: ListAccessControlRulesRequest): ListAccessControlRulesResponse

    /**
     * Creates a paginated call to list the aliases associated with a given entity.
     */
    public suspend fun listAliases(input: ListAliasesRequest): ListAliasesResponse

    /**
     * List all the `AvailabilityConfiguration`'s for the given WorkMail organization.
     */
    public suspend fun listAvailabilityConfigurations(input: ListAvailabilityConfigurationsRequest): ListAvailabilityConfigurationsResponse

    /**
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     */
    public suspend fun listGroupMembers(input: ListGroupMembersRequest): ListGroupMembersResponse

    /**
     * Returns summaries of the organization's groups.
     */
    public suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Returns all the groups to which an entity belongs.
     */
    public suspend fun listGroupsForEntity(input: ListGroupsForEntityRequest): ListGroupsForEntityResponse

    /**
     * Lists all the impersonation roles for the given WorkMail organization.
     */
    public suspend fun listImpersonationRoles(input: ListImpersonationRolesRequest): ListImpersonationRolesResponse

    /**
     * Lists the mail domains in a given WorkMail organization.
     */
    public suspend fun listMailDomains(input: ListMailDomainsRequest): ListMailDomainsResponse

    /**
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     */
    public suspend fun listMailboxExportJobs(input: ListMailboxExportJobsRequest): ListMailboxExportJobsResponse

    /**
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     */
    public suspend fun listMailboxPermissions(input: ListMailboxPermissionsRequest): ListMailboxPermissionsResponse

    /**
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     */
    public suspend fun listMobileDeviceAccessOverrides(input: ListMobileDeviceAccessOverridesRequest): ListMobileDeviceAccessOverridesResponse

    /**
     * Lists the mobile device access rules for the specified WorkMail organization.
     */
    public suspend fun listMobileDeviceAccessRules(input: ListMobileDeviceAccessRulesRequest): ListMobileDeviceAccessRulesResponse

    /**
     * Returns summaries of the customer's organizations.
     */
    public suspend fun listOrganizations(input: ListOrganizationsRequest = ListOrganizationsRequest { }): ListOrganizationsResponse

    /**
     * Returns a summary of your Personal Access Tokens.
     */
    public suspend fun listPersonalAccessTokens(input: ListPersonalAccessTokensRequest): ListPersonalAccessTokensResponse

    /**
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.
     */
    public suspend fun listResourceDelegates(input: ListResourceDelegatesRequest): ListResourceDelegatesResponse

    /**
     * Returns summaries of the organization's resources.
     */
    public suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse

    /**
     * Lists the tags applied to an WorkMail organization resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns summaries of the organization's users.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a new rule with the same name as an existing rule replaces the older rule.
     */
    public suspend fun putAccessControlRule(input: PutAccessControlRuleRequest): PutAccessControlRuleResponse

    /**
     * Creates or updates the email monitoring configuration for a specified organization.
     */
    public suspend fun putEmailMonitoringConfiguration(input: PutEmailMonitoringConfigurationRequest): PutEmailMonitoringConfigurationResponse

    /**
     * Enables integration between IAM Identity Center (IdC) and WorkMail to proxy authentication requests for mailbox users. You can connect your IdC directory or your external directory to WorkMail through IdC and manage access to WorkMail mailboxes in a single place. For enhanced protection, you could enable Multifactor Authentication (MFA) and Personal Access Tokens.
     */
    public suspend fun putIdentityProviderConfiguration(input: PutIdentityProviderConfigurationRequest): PutIdentityProviderConfigurationResponse

    /**
     * Enables or disables a DMARC policy for a given organization.
     */
    public suspend fun putInboundDmarcSettings(input: PutInboundDmarcSettingsRequest): PutInboundDmarcSettingsResponse

    /**
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     */
    public suspend fun putMailboxPermissions(input: PutMailboxPermissionsRequest): PutMailboxPermissionsResponse

    /**
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     */
    public suspend fun putMobileDeviceAccessOverride(input: PutMobileDeviceAccessOverrideRequest): PutMobileDeviceAccessOverrideResponse

    /**
     * Puts a retention policy to the specified organization.
     */
    public suspend fun putRetentionPolicy(input: PutRetentionPolicyRequest): PutRetentionPolicyResponse

    /**
     * Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the specified domain for sending your users' emails.
     */
    public suspend fun registerMailDomain(input: RegisterMailDomainRequest): RegisterMailDomainResponse

    /**
     * Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see [Pricing](https://aws.amazon.com/workmail/pricing). The equivalent console functionality for this operation is *Enable*.
     *
     * Users can either be created by calling the CreateUser API operation or they can be synchronized from your directory. For more information, see DeregisterFromWorkMail.
     */
    public suspend fun registerToWorkMail(input: RegisterToWorkMailRequest): RegisterToWorkMailResponse

    /**
     * Allows the administrator to reset the password for a user.
     */
    public suspend fun resetPassword(input: ResetPasswordRequest): ResetPasswordResponse

    /**
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see [Exporting mailbox content](https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html) in the *WorkMail Administrator Guide*.
     */
    public suspend fun startMailboxExportJob(input: StartMailboxExportJobRequest): StartMailboxExportJobResponse

    /**
     * Applies the specified tags to the specified WorkMailorganization resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done without providing either a `SourceArn` or `SourceAccount` header.
     *
     * The request must contain either one provider definition (`EwsProvider` or `LambdaProvider`) or the `DomainName` parameter. If the `DomainName` parameter is provided, the configuration stored under the `DomainName` will be tested.
     */
    public suspend fun testAvailabilityConfiguration(input: TestAvailabilityConfigurationRequest): TestAvailabilityConfigurationResponse

    /**
     * Untags the specified tags from the specified WorkMail organization resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing `AvailabilityConfiguration` for the given WorkMail organization and domain.
     */
    public suspend fun updateAvailabilityConfiguration(input: UpdateAvailabilityConfigurationRequest): UpdateAvailabilityConfigurationResponse

    /**
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.
     */
    public suspend fun updateDefaultMailDomain(input: UpdateDefaultMailDomainRequest): UpdateDefaultMailDomainResponse

    /**
     * Updates attributes in a group.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates an impersonation role for the given WorkMail organization.
     */
    public suspend fun updateImpersonationRole(input: UpdateImpersonationRoleRequest): UpdateImpersonationRoleResponse

    /**
     * Updates a user's current mailbox quota for a specified organization and user.
     */
    public suspend fun updateMailboxQuota(input: UpdateMailboxQuotaRequest): UpdateMailboxQuotaResponse

    /**
     * Updates a mobile device access rule for the specified WorkMail organization.
     */
    public suspend fun updateMobileDeviceAccessRule(input: UpdateMobileDeviceAccessRuleRequest): UpdateMobileDeviceAccessRuleResponse

    /**
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.
     */
    public suspend fun updatePrimaryEmailAddress(input: UpdatePrimaryEmailAddressRequest): UpdatePrimaryEmailAddressResponse

    /**
     * Updates data for the resource. To have the latest information, it must be preceded by a DescribeResource call. The dataset in the request should be the one expected when performing another `DescribeResource` call.
     */
    public suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse

    /**
     * Updates data for the user. To have the latest information, it must be preceded by a DescribeUser call. The dataset in the request should be the one expected when performing another `DescribeUser` call.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WorkMailClient.withConfig(block: WorkMailClient.Config.Builder.() -> Unit): WorkMailClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWorkMailClient(newConfig)
}

/**
 * Adds a member (user or group) to the resource's set of delegates.
 */
public suspend inline fun WorkMailClient.associateDelegateToResource(crossinline block: AssociateDelegateToResourceRequest.Builder.() -> Unit): AssociateDelegateToResourceResponse = associateDelegateToResource(AssociateDelegateToResourceRequest.Builder().apply(block).build())

/**
 * Adds a member (user or group) to the group's set.
 */
public suspend inline fun WorkMailClient.associateMemberToGroup(crossinline block: AssociateMemberToGroupRequest.Builder.() -> Unit): AssociateMemberToGroupResponse = associateMemberToGroup(AssociateMemberToGroupRequest.Builder().apply(block).build())

/**
 * Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token you can use to make impersonated calls.
 */
public suspend inline fun WorkMailClient.assumeImpersonationRole(crossinline block: AssumeImpersonationRoleRequest.Builder.() -> Unit): AssumeImpersonationRoleResponse = assumeImpersonationRole(AssumeImpersonationRoleRequest.Builder().apply(block).build())

/**
 * Cancels a mailbox export job.
 *
 * If the mailbox export job is near completion, it might not be possible to cancel it.
 */
public suspend inline fun WorkMailClient.cancelMailboxExportJob(crossinline block: CancelMailboxExportJobRequest.Builder.() -> Unit): CancelMailboxExportJobResponse = cancelMailboxExportJob(CancelMailboxExportJobRequest.Builder().apply(block).build())

/**
 * Adds an alias to the set of a given member (user or group) of WorkMail.
 */
public suspend inline fun WorkMailClient.createAlias(crossinline block: CreateAliasRequest.Builder.() -> Unit): CreateAliasResponse = createAlias(CreateAliasRequest.Builder().apply(block).build())

/**
 * Creates an `AvailabilityConfiguration` for the given WorkMail organization and domain.
 */
public suspend inline fun WorkMailClient.createAvailabilityConfiguration(crossinline block: CreateAvailabilityConfigurationRequest.Builder.() -> Unit): CreateAvailabilityConfigurationResponse = createAvailabilityConfiguration(CreateAvailabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a group that can be used in WorkMail by calling the RegisterToWorkMail operation.
 */
public suspend inline fun WorkMailClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates the WorkMail application in IAM Identity Center that can be used later in the WorkMail - IdC integration. For more information, see PutIdentityProviderConfiguration. This action does not affect the authentication settings for any WorkMail organizations.
 */
public suspend inline fun WorkMailClient.createIdentityCenterApplication(crossinline block: CreateIdentityCenterApplicationRequest.Builder.() -> Unit): CreateIdentityCenterApplicationResponse = createIdentityCenterApplication(CreateIdentityCenterApplicationRequest.Builder().apply(block).build())

/**
 * Creates an impersonation role for the given WorkMail organization.
 *
 * *Idempotency* ensures that an API request completes no more than one time. With an idempotent request, if the original request completes successfully, any subsequent retries also complete successfully without performing any further actions.
 */
public suspend inline fun WorkMailClient.createImpersonationRole(crossinline block: CreateImpersonationRoleRequest.Builder.() -> Unit): CreateImpersonationRoleResponse = createImpersonationRole(CreateImpersonationRoleRequest.Builder().apply(block).build())

/**
 * Creates a new mobile device access rule for the specified WorkMail organization.
 */
public suspend inline fun WorkMailClient.createMobileDeviceAccessRule(crossinline block: CreateMobileDeviceAccessRuleRequest.Builder.() -> Unit): CreateMobileDeviceAccessRuleResponse = createMobileDeviceAccessRule(CreateMobileDeviceAccessRuleRequest.Builder().apply(block).build())

/**
 * Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new WorkMail directory for you. For more information, see [Adding an organization](https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html) in the *WorkMail Administrator Guide*.
 *
 * You can associate multiple email domains with an organization, then choose your default email domain from the WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see [Adding a domain](https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html) and [Choosing the default domain](https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html) in the *WorkMail Administrator Guide*.
 *
 * Optionally, you can use a customer managed key from AWS Key Management Service (AWS KMS) to encrypt email for your organization. If you don't associate an AWS KMS key, WorkMail creates a default, AWS managed key for you.
 */
public suspend inline fun WorkMailClient.createOrganization(crossinline block: CreateOrganizationRequest.Builder.() -> Unit): CreateOrganizationResponse = createOrganization(CreateOrganizationRequest.Builder().apply(block).build())

/**
 * Creates a new WorkMail resource.
 */
public suspend inline fun WorkMailClient.createResource(crossinline block: CreateResourceRequest.Builder.() -> Unit): CreateResourceResponse = createResource(CreateResourceRequest.Builder().apply(block).build())

/**
 * Creates a user who can be used in WorkMail by calling the RegisterToWorkMail operation.
 */
public suspend inline fun WorkMailClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Deletes an access control rule for the specified WorkMail organization.
 *
 * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
 */
public suspend inline fun WorkMailClient.deleteAccessControlRule(crossinline block: DeleteAccessControlRuleRequest.Builder.() -> Unit): DeleteAccessControlRuleResponse = deleteAccessControlRule(DeleteAccessControlRuleRequest.Builder().apply(block).build())

/**
 * Remove one or more specified aliases from a set of aliases for a given user.
 */
public suspend inline fun WorkMailClient.deleteAlias(crossinline block: DeleteAliasRequest.Builder.() -> Unit): DeleteAliasResponse = deleteAlias(DeleteAliasRequest.Builder().apply(block).build())

/**
 * Deletes the `AvailabilityConfiguration` for the given WorkMail organization and domain.
 */
public suspend inline fun WorkMailClient.deleteAvailabilityConfiguration(crossinline block: DeleteAvailabilityConfigurationRequest.Builder.() -> Unit): DeleteAvailabilityConfigurationResponse = deleteAvailabilityConfiguration(DeleteAvailabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the email monitoring configuration for a specified organization.
 */
public suspend inline fun WorkMailClient.deleteEmailMonitoringConfiguration(crossinline block: DeleteEmailMonitoringConfigurationRequest.Builder.() -> Unit): DeleteEmailMonitoringConfigurationResponse = deleteEmailMonitoringConfiguration(DeleteEmailMonitoringConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a group from WorkMail.
 */
public suspend inline fun WorkMailClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes the IAM Identity Center application from WorkMail. This action does not affect the authentication settings for any WorkMail organizations.
 */
public suspend inline fun WorkMailClient.deleteIdentityCenterApplication(crossinline block: DeleteIdentityCenterApplicationRequest.Builder.() -> Unit): DeleteIdentityCenterApplicationResponse = deleteIdentityCenterApplication(DeleteIdentityCenterApplicationRequest.Builder().apply(block).build())

/**
 * Disables the integration between IdC and WorkMail. Authentication will continue with the directory as it was before the IdC integration. You might have to reset your directory passwords and reconfigure your desktop and mobile email clients.
 */
public suspend inline fun WorkMailClient.deleteIdentityProviderConfiguration(crossinline block: DeleteIdentityProviderConfigurationRequest.Builder.() -> Unit): DeleteIdentityProviderConfigurationResponse = deleteIdentityProviderConfiguration(DeleteIdentityProviderConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an impersonation role for the given WorkMail organization.
 */
public suspend inline fun WorkMailClient.deleteImpersonationRole(crossinline block: DeleteImpersonationRoleRequest.Builder.() -> Unit): DeleteImpersonationRoleResponse = deleteImpersonationRole(DeleteImpersonationRoleRequest.Builder().apply(block).build())

/**
 * Deletes permissions granted to a member (user or group).
 */
public suspend inline fun WorkMailClient.deleteMailboxPermissions(crossinline block: DeleteMailboxPermissionsRequest.Builder.() -> Unit): DeleteMailboxPermissionsResponse = deleteMailboxPermissions(DeleteMailboxPermissionsRequest.Builder().apply(block).build())

/**
 * Deletes the mobile device access override for the given WorkMail organization, user, and device.
 *
 * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
 */
public suspend inline fun WorkMailClient.deleteMobileDeviceAccessOverride(crossinline block: DeleteMobileDeviceAccessOverrideRequest.Builder.() -> Unit): DeleteMobileDeviceAccessOverrideResponse = deleteMobileDeviceAccessOverride(DeleteMobileDeviceAccessOverrideRequest.Builder().apply(block).build())

/**
 * Deletes a mobile device access rule for the specified WorkMail organization.
 *
 * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.
 */
public suspend inline fun WorkMailClient.deleteMobileDeviceAccessRule(crossinline block: DeleteMobileDeviceAccessRuleRequest.Builder.() -> Unit): DeleteMobileDeviceAccessRuleResponse = deleteMobileDeviceAccessRule(DeleteMobileDeviceAccessRuleRequest.Builder().apply(block).build())

/**
 * Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see [Removing an organization](https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html) in the *WorkMail Administrator Guide*.
 */
public suspend inline fun WorkMailClient.deleteOrganization(crossinline block: DeleteOrganizationRequest.Builder.() -> Unit): DeleteOrganizationResponse = deleteOrganization(DeleteOrganizationRequest.Builder().apply(block).build())

/**
 * Deletes the Personal Access Token from the provided WorkMail Organization.
 */
public suspend inline fun WorkMailClient.deletePersonalAccessToken(crossinline block: DeletePersonalAccessTokenRequest.Builder.() -> Unit): DeletePersonalAccessTokenResponse = deletePersonalAccessToken(DeletePersonalAccessTokenRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource.
 */
public suspend inline fun WorkMailClient.deleteResource(crossinline block: DeleteResourceRequest.Builder.() -> Unit): DeleteResourceResponse = deleteResource(DeleteResourceRequest.Builder().apply(block).build())

/**
 * Deletes the specified retention policy from the specified organization.
 */
public suspend inline fun WorkMailClient.deleteRetentionPolicy(crossinline block: DeleteRetentionPolicyRequest.Builder.() -> Unit): DeleteRetentionPolicyResponse = deleteRetentionPolicy(DeleteRetentionPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be `DISABLED`. Use the DescribeUser action to confirm the user state.
 *
 * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are permanently removed.
 */
public suspend inline fun WorkMailClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is *Disable*.
 */
public suspend inline fun WorkMailClient.deregisterFromWorkMail(crossinline block: DeregisterFromWorkMailRequest.Builder.() -> Unit): DeregisterFromWorkMailResponse = deregisterFromWorkMail(DeregisterFromWorkMailRequest.Builder().apply(block).build())

/**
 * Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address used by WorkMail entities before you remove the domain.
 */
public suspend inline fun WorkMailClient.deregisterMailDomain(crossinline block: DeregisterMailDomainRequest.Builder.() -> Unit): DeregisterMailDomainResponse = deregisterMailDomain(DeregisterMailDomainRequest.Builder().apply(block).build())

/**
 * Describes the current email monitoring configuration for a specified organization.
 */
public suspend inline fun WorkMailClient.describeEmailMonitoringConfiguration(crossinline block: DescribeEmailMonitoringConfigurationRequest.Builder.() -> Unit): DescribeEmailMonitoringConfigurationResponse = describeEmailMonitoringConfiguration(DescribeEmailMonitoringConfigurationRequest.Builder().apply(block).build())

/**
 * Returns basic details about an entity in WorkMail.
 */
public suspend inline fun WorkMailClient.describeEntity(crossinline block: DescribeEntityRequest.Builder.() -> Unit): DescribeEntityResponse = describeEntity(DescribeEntityRequest.Builder().apply(block).build())

/**
 * Returns the data available for the group.
 */
public suspend inline fun WorkMailClient.describeGroup(crossinline block: DescribeGroupRequest.Builder.() -> Unit): DescribeGroupResponse = describeGroup(DescribeGroupRequest.Builder().apply(block).build())

/**
 * Returns detailed information on the current IdC setup for the WorkMail organization.
 */
public suspend inline fun WorkMailClient.describeIdentityProviderConfiguration(crossinline block: DescribeIdentityProviderConfigurationRequest.Builder.() -> Unit): DescribeIdentityProviderConfigurationResponse = describeIdentityProviderConfiguration(DescribeIdentityProviderConfigurationRequest.Builder().apply(block).build())

/**
 * Lists the settings in a DMARC policy for a specified organization.
 */
public suspend inline fun WorkMailClient.describeInboundDmarcSettings(crossinline block: DescribeInboundDmarcSettingsRequest.Builder.() -> Unit): DescribeInboundDmarcSettingsResponse = describeInboundDmarcSettings(DescribeInboundDmarcSettingsRequest.Builder().apply(block).build())

/**
 * Describes the current status of a mailbox export job.
 */
public suspend inline fun WorkMailClient.describeMailboxExportJob(crossinline block: DescribeMailboxExportJobRequest.Builder.() -> Unit): DescribeMailboxExportJobResponse = describeMailboxExportJob(DescribeMailboxExportJobRequest.Builder().apply(block).build())

/**
 * Provides more information regarding a given organization based on its identifier.
 */
public suspend inline fun WorkMailClient.describeOrganization(crossinline block: DescribeOrganizationRequest.Builder.() -> Unit): DescribeOrganizationResponse = describeOrganization(DescribeOrganizationRequest.Builder().apply(block).build())

/**
 * Returns the data available for the resource.
 */
public suspend inline fun WorkMailClient.describeResource(crossinline block: DescribeResourceRequest.Builder.() -> Unit): DescribeResourceResponse = describeResource(DescribeResourceRequest.Builder().apply(block).build())

/**
 * Provides information regarding the user.
 */
public suspend inline fun WorkMailClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Removes a member from the resource's set of delegates.
 */
public suspend inline fun WorkMailClient.disassociateDelegateFromResource(crossinline block: DisassociateDelegateFromResourceRequest.Builder.() -> Unit): DisassociateDelegateFromResourceResponse = disassociateDelegateFromResource(DisassociateDelegateFromResourceRequest.Builder().apply(block).build())

/**
 * Removes a member from a group.
 */
public suspend inline fun WorkMailClient.disassociateMemberFromGroup(crossinline block: DisassociateMemberFromGroupRequest.Builder.() -> Unit): DisassociateMemberFromGroupResponse = disassociateMemberFromGroup(DisassociateMemberFromGroupRequest.Builder().apply(block).build())

/**
 * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role ID. Impersonation role ID can only be used with Action EWS.
 */
public suspend inline fun WorkMailClient.getAccessControlEffect(crossinline block: GetAccessControlEffectRequest.Builder.() -> Unit): GetAccessControlEffectResponse = getAccessControlEffect(GetAccessControlEffectRequest.Builder().apply(block).build())

/**
 * Gets the default retention policy details for the specified organization.
 */
public suspend inline fun WorkMailClient.getDefaultRetentionPolicy(crossinline block: GetDefaultRetentionPolicyRequest.Builder.() -> Unit): GetDefaultRetentionPolicyResponse = getDefaultRetentionPolicy(GetDefaultRetentionPolicyRequest.Builder().apply(block).build())

/**
 * Gets the impersonation role details for the given WorkMail organization.
 */
public suspend inline fun WorkMailClient.getImpersonationRole(crossinline block: GetImpersonationRoleRequest.Builder.() -> Unit): GetImpersonationRoleResponse = getImpersonationRole(GetImpersonationRoleRequest.Builder().apply(block).build())

/**
 * Tests whether the given impersonation role can impersonate a target user.
 */
public suspend inline fun WorkMailClient.getImpersonationRoleEffect(crossinline block: GetImpersonationRoleEffectRequest.Builder.() -> Unit): GetImpersonationRoleEffectResponse = getImpersonationRoleEffect(GetImpersonationRoleEffectRequest.Builder().apply(block).build())

/**
 * Gets details for a mail domain, including domain records required to configure your domain with recommended security.
 */
public suspend inline fun WorkMailClient.getMailDomain(crossinline block: GetMailDomainRequest.Builder.() -> Unit): GetMailDomainResponse = getMailDomain(GetMailDomainRequest.Builder().apply(block).build())

/**
 * Requests a user's mailbox details for a specified organization and user.
 */
public suspend inline fun WorkMailClient.getMailboxDetails(crossinline block: GetMailboxDetailsRequest.Builder.() -> Unit): GetMailboxDetailsResponse = getMailboxDetails(GetMailboxDetailsRequest.Builder().apply(block).build())

/**
 * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the WorkMail organization for a particular user's attributes.
 */
public suspend inline fun WorkMailClient.getMobileDeviceAccessEffect(crossinline block: GetMobileDeviceAccessEffectRequest.Builder.() -> Unit): GetMobileDeviceAccessEffectResponse = getMobileDeviceAccessEffect(GetMobileDeviceAccessEffectRequest.Builder().apply(block).build())

/**
 * Gets the mobile device access override for the given WorkMail organization, user, and device.
 */
public suspend inline fun WorkMailClient.getMobileDeviceAccessOverride(crossinline block: GetMobileDeviceAccessOverrideRequest.Builder.() -> Unit): GetMobileDeviceAccessOverrideResponse = getMobileDeviceAccessOverride(GetMobileDeviceAccessOverrideRequest.Builder().apply(block).build())

/**
 * Requests details of a specific Personal Access Token within the WorkMail organization.
 */
public suspend inline fun WorkMailClient.getPersonalAccessTokenMetadata(crossinline block: GetPersonalAccessTokenMetadataRequest.Builder.() -> Unit): GetPersonalAccessTokenMetadataResponse = getPersonalAccessTokenMetadata(GetPersonalAccessTokenMetadataRequest.Builder().apply(block).build())

/**
 * Lists the access control rules for the specified organization.
 */
public suspend inline fun WorkMailClient.listAccessControlRules(crossinline block: ListAccessControlRulesRequest.Builder.() -> Unit): ListAccessControlRulesResponse = listAccessControlRules(ListAccessControlRulesRequest.Builder().apply(block).build())

/**
 * Creates a paginated call to list the aliases associated with a given entity.
 */
public suspend inline fun WorkMailClient.listAliases(crossinline block: ListAliasesRequest.Builder.() -> Unit): ListAliasesResponse = listAliases(ListAliasesRequest.Builder().apply(block).build())

/**
 * List all the `AvailabilityConfiguration`'s for the given WorkMail organization.
 */
public suspend inline fun WorkMailClient.listAvailabilityConfigurations(crossinline block: ListAvailabilityConfigurationsRequest.Builder.() -> Unit): ListAvailabilityConfigurationsResponse = listAvailabilityConfigurations(ListAvailabilityConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns an overview of the members of a group. Users and groups can be members of a group.
 */
public suspend inline fun WorkMailClient.listGroupMembers(crossinline block: ListGroupMembersRequest.Builder.() -> Unit): ListGroupMembersResponse = listGroupMembers(ListGroupMembersRequest.Builder().apply(block).build())

/**
 * Returns summaries of the organization's groups.
 */
public suspend inline fun WorkMailClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Returns all the groups to which an entity belongs.
 */
public suspend inline fun WorkMailClient.listGroupsForEntity(crossinline block: ListGroupsForEntityRequest.Builder.() -> Unit): ListGroupsForEntityResponse = listGroupsForEntity(ListGroupsForEntityRequest.Builder().apply(block).build())

/**
 * Lists all the impersonation roles for the given WorkMail organization.
 */
public suspend inline fun WorkMailClient.listImpersonationRoles(crossinline block: ListImpersonationRolesRequest.Builder.() -> Unit): ListImpersonationRolesResponse = listImpersonationRoles(ListImpersonationRolesRequest.Builder().apply(block).build())

/**
 * Lists the mail domains in a given WorkMail organization.
 */
public suspend inline fun WorkMailClient.listMailDomains(crossinline block: ListMailDomainsRequest.Builder.() -> Unit): ListMailDomainsResponse = listMailDomains(ListMailDomainsRequest.Builder().apply(block).build())

/**
 * Lists the mailbox export jobs started for the specified organization within the last seven days.
 */
public suspend inline fun WorkMailClient.listMailboxExportJobs(crossinline block: ListMailboxExportJobsRequest.Builder.() -> Unit): ListMailboxExportJobsResponse = listMailboxExportJobs(ListMailboxExportJobsRequest.Builder().apply(block).build())

/**
 * Lists the mailbox permissions associated with a user, group, or resource mailbox.
 */
public suspend inline fun WorkMailClient.listMailboxPermissions(crossinline block: ListMailboxPermissionsRequest.Builder.() -> Unit): ListMailboxPermissionsResponse = listMailboxPermissions(ListMailboxPermissionsRequest.Builder().apply(block).build())

/**
 * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
 */
public suspend inline fun WorkMailClient.listMobileDeviceAccessOverrides(crossinline block: ListMobileDeviceAccessOverridesRequest.Builder.() -> Unit): ListMobileDeviceAccessOverridesResponse = listMobileDeviceAccessOverrides(ListMobileDeviceAccessOverridesRequest.Builder().apply(block).build())

/**
 * Lists the mobile device access rules for the specified WorkMail organization.
 */
public suspend inline fun WorkMailClient.listMobileDeviceAccessRules(crossinline block: ListMobileDeviceAccessRulesRequest.Builder.() -> Unit): ListMobileDeviceAccessRulesResponse = listMobileDeviceAccessRules(ListMobileDeviceAccessRulesRequest.Builder().apply(block).build())

/**
 * Returns summaries of the customer's organizations.
 */
public suspend inline fun WorkMailClient.listOrganizations(crossinline block: ListOrganizationsRequest.Builder.() -> Unit): ListOrganizationsResponse = listOrganizations(ListOrganizationsRequest.Builder().apply(block).build())

/**
 * Returns a summary of your Personal Access Tokens.
 */
public suspend inline fun WorkMailClient.listPersonalAccessTokens(crossinline block: ListPersonalAccessTokensRequest.Builder.() -> Unit): ListPersonalAccessTokensResponse = listPersonalAccessTokens(ListPersonalAccessTokensRequest.Builder().apply(block).build())

/**
 * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.
 */
public suspend inline fun WorkMailClient.listResourceDelegates(crossinline block: ListResourceDelegatesRequest.Builder.() -> Unit): ListResourceDelegatesResponse = listResourceDelegates(ListResourceDelegatesRequest.Builder().apply(block).build())

/**
 * Returns summaries of the organization's resources.
 */
public suspend inline fun WorkMailClient.listResources(crossinline block: ListResourcesRequest.Builder.() -> Unit): ListResourcesResponse = listResources(ListResourcesRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an WorkMail organization resource.
 */
public suspend inline fun WorkMailClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns summaries of the organization's users.
 */
public suspend inline fun WorkMailClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a new rule with the same name as an existing rule replaces the older rule.
 */
public suspend inline fun WorkMailClient.putAccessControlRule(crossinline block: PutAccessControlRuleRequest.Builder.() -> Unit): PutAccessControlRuleResponse = putAccessControlRule(PutAccessControlRuleRequest.Builder().apply(block).build())

/**
 * Creates or updates the email monitoring configuration for a specified organization.
 */
public suspend inline fun WorkMailClient.putEmailMonitoringConfiguration(crossinline block: PutEmailMonitoringConfigurationRequest.Builder.() -> Unit): PutEmailMonitoringConfigurationResponse = putEmailMonitoringConfiguration(PutEmailMonitoringConfigurationRequest.Builder().apply(block).build())

/**
 * Enables integration between IAM Identity Center (IdC) and WorkMail to proxy authentication requests for mailbox users. You can connect your IdC directory or your external directory to WorkMail through IdC and manage access to WorkMail mailboxes in a single place. For enhanced protection, you could enable Multifactor Authentication (MFA) and Personal Access Tokens.
 */
public suspend inline fun WorkMailClient.putIdentityProviderConfiguration(crossinline block: PutIdentityProviderConfigurationRequest.Builder.() -> Unit): PutIdentityProviderConfigurationResponse = putIdentityProviderConfiguration(PutIdentityProviderConfigurationRequest.Builder().apply(block).build())

/**
 * Enables or disables a DMARC policy for a given organization.
 */
public suspend inline fun WorkMailClient.putInboundDmarcSettings(crossinline block: PutInboundDmarcSettingsRequest.Builder.() -> Unit): PutInboundDmarcSettingsResponse = putInboundDmarcSettings(PutInboundDmarcSettingsRequest.Builder().apply(block).build())

/**
 * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
 */
public suspend inline fun WorkMailClient.putMailboxPermissions(crossinline block: PutMailboxPermissionsRequest.Builder.() -> Unit): PutMailboxPermissionsResponse = putMailboxPermissions(PutMailboxPermissionsRequest.Builder().apply(block).build())

/**
 * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
 */
public suspend inline fun WorkMailClient.putMobileDeviceAccessOverride(crossinline block: PutMobileDeviceAccessOverrideRequest.Builder.() -> Unit): PutMobileDeviceAccessOverrideResponse = putMobileDeviceAccessOverride(PutMobileDeviceAccessOverrideRequest.Builder().apply(block).build())

/**
 * Puts a retention policy to the specified organization.
 */
public suspend inline fun WorkMailClient.putRetentionPolicy(crossinline block: PutRetentionPolicyRequest.Builder.() -> Unit): PutRetentionPolicyResponse = putRetentionPolicy(PutRetentionPolicyRequest.Builder().apply(block).build())

/**
 * Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the specified domain for sending your users' emails.
 */
public suspend inline fun WorkMailClient.registerMailDomain(crossinline block: RegisterMailDomainRequest.Builder.() -> Unit): RegisterMailDomainResponse = registerMailDomain(RegisterMailDomainRequest.Builder().apply(block).build())

/**
 * Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see [Pricing](https://aws.amazon.com/workmail/pricing). The equivalent console functionality for this operation is *Enable*.
 *
 * Users can either be created by calling the CreateUser API operation or they can be synchronized from your directory. For more information, see DeregisterFromWorkMail.
 */
public suspend inline fun WorkMailClient.registerToWorkMail(crossinline block: RegisterToWorkMailRequest.Builder.() -> Unit): RegisterToWorkMailResponse = registerToWorkMail(RegisterToWorkMailRequest.Builder().apply(block).build())

/**
 * Allows the administrator to reset the password for a user.
 */
public suspend inline fun WorkMailClient.resetPassword(crossinline block: ResetPasswordRequest.Builder.() -> Unit): ResetPasswordResponse = resetPassword(ResetPasswordRequest.Builder().apply(block).build())

/**
 * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see [Exporting mailbox content](https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html) in the *WorkMail Administrator Guide*.
 */
public suspend inline fun WorkMailClient.startMailboxExportJob(crossinline block: StartMailboxExportJobRequest.Builder.() -> Unit): StartMailboxExportJobResponse = startMailboxExportJob(StartMailboxExportJobRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified WorkMailorganization resource.
 */
public suspend inline fun WorkMailClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done without providing either a `SourceArn` or `SourceAccount` header.
 *
 * The request must contain either one provider definition (`EwsProvider` or `LambdaProvider`) or the `DomainName` parameter. If the `DomainName` parameter is provided, the configuration stored under the `DomainName` will be tested.
 */
public suspend inline fun WorkMailClient.testAvailabilityConfiguration(crossinline block: TestAvailabilityConfigurationRequest.Builder.() -> Unit): TestAvailabilityConfigurationResponse = testAvailabilityConfiguration(TestAvailabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Untags the specified tags from the specified WorkMail organization resource.
 */
public suspend inline fun WorkMailClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing `AvailabilityConfiguration` for the given WorkMail organization and domain.
 */
public suspend inline fun WorkMailClient.updateAvailabilityConfiguration(crossinline block: UpdateAvailabilityConfigurationRequest.Builder.() -> Unit): UpdateAvailabilityConfigurationResponse = updateAvailabilityConfiguration(UpdateAvailabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.
 */
public suspend inline fun WorkMailClient.updateDefaultMailDomain(crossinline block: UpdateDefaultMailDomainRequest.Builder.() -> Unit): UpdateDefaultMailDomainResponse = updateDefaultMailDomain(UpdateDefaultMailDomainRequest.Builder().apply(block).build())

/**
 * Updates attributes in a group.
 */
public suspend inline fun WorkMailClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Updates an impersonation role for the given WorkMail organization.
 */
public suspend inline fun WorkMailClient.updateImpersonationRole(crossinline block: UpdateImpersonationRoleRequest.Builder.() -> Unit): UpdateImpersonationRoleResponse = updateImpersonationRole(UpdateImpersonationRoleRequest.Builder().apply(block).build())

/**
 * Updates a user's current mailbox quota for a specified organization and user.
 */
public suspend inline fun WorkMailClient.updateMailboxQuota(crossinline block: UpdateMailboxQuotaRequest.Builder.() -> Unit): UpdateMailboxQuotaResponse = updateMailboxQuota(UpdateMailboxQuotaRequest.Builder().apply(block).build())

/**
 * Updates a mobile device access rule for the specified WorkMail organization.
 */
public suspend inline fun WorkMailClient.updateMobileDeviceAccessRule(crossinline block: UpdateMobileDeviceAccessRuleRequest.Builder.() -> Unit): UpdateMobileDeviceAccessRuleResponse = updateMobileDeviceAccessRule(UpdateMobileDeviceAccessRuleRequest.Builder().apply(block).build())

/**
 * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.
 */
public suspend inline fun WorkMailClient.updatePrimaryEmailAddress(crossinline block: UpdatePrimaryEmailAddressRequest.Builder.() -> Unit): UpdatePrimaryEmailAddressResponse = updatePrimaryEmailAddress(UpdatePrimaryEmailAddressRequest.Builder().apply(block).build())

/**
 * Updates data for the resource. To have the latest information, it must be preceded by a DescribeResource call. The dataset in the request should be the one expected when performing another `DescribeResource` call.
 */
public suspend inline fun WorkMailClient.updateResource(crossinline block: UpdateResourceRequest.Builder.() -> Unit): UpdateResourceResponse = updateResource(UpdateResourceRequest.Builder().apply(block).build())

/**
 * Updates data for the user. To have the latest information, it must be preceded by a DescribeUser call. The dataset in the request should be the one expected when performing another `DescribeUser` call.
 */
public suspend inline fun WorkMailClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
