// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.DnsRecord
import aws.sdk.kotlin.services.workmail.model.DnsRecordVerificationStatus
import aws.sdk.kotlin.services.workmail.model.GetMailDomainResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetMailDomainOperationDeserializer: HttpDeserializer.NonStreaming<GetMailDomainResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMailDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMailDomainError(context, call, payload)
        }
        val builder = GetMailDomainResponse.Builder()

        if (payload != null) {
            deserializeGetMailDomainOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMailDomainError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MailDomainNotFoundException" -> MailDomainNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMailDomainOperationBody(builder: GetMailDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DKIMVERIFICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DkimVerificationStatus"))
    val ISDEFAULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsDefault"))
    val ISTESTDOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsTestDomain"))
    val OWNERSHIPVERIFICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OwnershipVerificationStatus"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Records"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DKIMVERIFICATIONSTATUS_DESCRIPTOR)
        field(ISDEFAULT_DESCRIPTOR)
        field(ISTESTDOMAIN_DESCRIPTOR)
        field(OWNERSHIPVERIFICATIONSTATUS_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DKIMVERIFICATIONSTATUS_DESCRIPTOR.index -> builder.dkimVerificationStatus = deserializeString().let { DnsRecordVerificationStatus.fromValue(it) }
                ISDEFAULT_DESCRIPTOR.index -> builder.isDefault = deserializeBoolean()
                ISTESTDOMAIN_DESCRIPTOR.index -> builder.isTestDomain = deserializeBoolean()
                OWNERSHIPVERIFICATIONSTATUS_DESCRIPTOR.index -> builder.ownershipVerificationStatus = deserializeString().let { DnsRecordVerificationStatus.fromValue(it) }
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<DnsRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDnsRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
