// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.serde

import aws.sdk.kotlin.services.workmail.model.DescribeGroupResponse
import aws.sdk.kotlin.services.workmail.model.EntityState
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeGroupOperationDeserializer: HttpDeserializer.NonStreaming<DescribeGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeGroupError(context, call, payload)
        }
        val builder = DescribeGroupResponse.Builder()

        if (payload != null) {
            deserializeDescribeGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGroupOperationBody(builder: DescribeGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DisabledDate"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val ENABLEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EnabledDate"))
    val GROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupId"))
    val HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HiddenFromGlobalAddressList"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISABLEDDATE_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(ENABLEDDATE_DESCRIPTOR)
        field(GROUPID_DESCRIPTOR)
        field(HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISABLEDDATE_DESCRIPTOR.index -> builder.disabledDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                EMAIL_DESCRIPTOR.index -> builder.email = deserializeString()
                ENABLEDDATE_DESCRIPTOR.index -> builder.enabledDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                GROUPID_DESCRIPTOR.index -> builder.groupId = deserializeString()
                HIDDENFROMGLOBALADDRESSLIST_DESCRIPTOR.index -> builder.hiddenFromGlobalAddressList = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { EntityState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
