// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



public class PutMailboxPermissionsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the user or resource for which to update mailbox permissions.
     *
     * The identifier can be *UserId, ResourceID, or Group Id*, *Username, Resourcename, or Groupname*, or *email*.
     * + Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234
     * + Email address: entity@domain.tld
     * + Entity name: entity
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The identifier of the user, group, or resource to which to grant the permissions.
     *
     * The identifier can be *UserId, ResourceID, or Group Id*, *Username, Resourcename, or Groupname*, or *email*.
     * + Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234
     * + Email address: grantee@domain.tld
     * + Grantee name: grantee
     */
    public val granteeId: kotlin.String? = builder.granteeId
    /**
     * The identifier of the organization under which the user, group, or resource exists.
     */
    public val organizationId: kotlin.String? = builder.organizationId
    /**
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     */
    public val permissionValues: List<PermissionType>? = builder.permissionValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.PutMailboxPermissionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutMailboxPermissionsRequest(")
        append("entityId=$entityId,")
        append("granteeId=$granteeId,")
        append("organizationId=$organizationId,")
        append("permissionValues=$permissionValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityId?.hashCode() ?: 0
        result = 31 * result + (granteeId?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (permissionValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutMailboxPermissionsRequest

        if (entityId != other.entityId) return false
        if (granteeId != other.granteeId) return false
        if (organizationId != other.organizationId) return false
        if (permissionValues != other.permissionValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.PutMailboxPermissionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the user or resource for which to update mailbox permissions.
         *
         * The identifier can be *UserId, ResourceID, or Group Id*, *Username, Resourcename, or Groupname*, or *email*.
         * + Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234
         * + Email address: entity@domain.tld
         * + Entity name: entity
         */
        public var entityId: kotlin.String? = null
        /**
         * The identifier of the user, group, or resource to which to grant the permissions.
         *
         * The identifier can be *UserId, ResourceID, or Group Id*, *Username, Resourcename, or Groupname*, or *email*.
         * + Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234
         * + Email address: grantee@domain.tld
         * + Grantee name: grantee
         */
        public var granteeId: kotlin.String? = null
        /**
         * The identifier of the organization under which the user, group, or resource exists.
         */
        public var organizationId: kotlin.String? = null
        /**
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
         */
        public var permissionValues: List<PermissionType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.PutMailboxPermissionsRequest) : this() {
            this.entityId = x.entityId
            this.granteeId = x.granteeId
            this.organizationId = x.organizationId
            this.permissionValues = x.permissionValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.PutMailboxPermissionsRequest = PutMailboxPermissionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
