// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model



/**
 * The domain to associate with an WorkMail organization.
 *
 * When you configure a domain hosted in Amazon Route 53 (Route 53), all recommended DNS records are added to the organization when you create it. For more information, see [Adding a domain](https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html) in the *WorkMail Administrator Guide*.
 */
public class Domain private constructor(builder: Builder) {
    /**
     * The fully qualified domain name.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.Domain = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Domain(")
        append("domainName=$domainName,")
        append("hostedZoneId=$hostedZoneId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName.hashCode()
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Domain

        if (domainName != other.domainName) return false
        if (hostedZoneId != other.hostedZoneId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.Domain = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The fully qualified domain name.
         */
        public var domainName: kotlin.String? = null
        /**
         * The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.
         */
        public var hostedZoneId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.Domain) : this() {
            this.domainName = x.domainName
            this.hostedZoneId = x.hostedZoneId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.Domain = Domain(this)

        internal fun correctErrors(): Builder {
            if (domainName == null) domainName = ""
            return this
        }
    }
}
