// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.RegisterToWorkMailResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class RegisterToWorkMailOperationDeserializer: HttpDeserialize<RegisterToWorkMailResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterToWorkMailResponse {
        if (!response.status.isSuccess()) {
            throwRegisterToWorkMailError(context, response)
        }
        val builder = RegisterToWorkMailResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwRegisterToWorkMailError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectoryServiceAuthenticationFailedException" -> DirectoryServiceAuthenticationFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectoryUnavailableException" -> DirectoryUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "EmailAddressInUseException" -> EmailAddressInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityAlreadyRegisteredException" -> EntityAlreadyRegisteredExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityStateException" -> EntityStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "MailDomainNotFoundException" -> MailDomainNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "MailDomainStateException" -> MailDomainStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
