// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleResponse
import aws.sdk.kotlin.services.workmail.model.ImpersonationRoleType
import aws.sdk.kotlin.services.workmail.model.ImpersonationRule
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetImpersonationRoleOperationDeserializer: HttpDeserialize<GetImpersonationRoleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetImpersonationRoleResponse {
        if (!response.status.isSuccess()) {
            throwGetImpersonationRoleError(context, response)
        }
        val builder = GetImpersonationRoleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetImpersonationRoleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetImpersonationRoleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetImpersonationRoleOperationBody(builder: GetImpersonationRoleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateCreated"))
    val DATEMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateModified"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val IMPERSONATIONROLEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImpersonationRoleId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Rules"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATECREATED_DESCRIPTOR)
        field(DATEMODIFIED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(IMPERSONATIONROLEID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RULES_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATEMODIFIED_DESCRIPTOR.index -> builder.dateModified = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                IMPERSONATIONROLEID_DESCRIPTOR.index -> builder.impersonationRoleId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RULES_DESCRIPTOR.index -> builder.rules =
                    deserializer.deserializeList(RULES_DESCRIPTOR) {
                        val col0 = mutableListOf<ImpersonationRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImpersonationRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ImpersonationRoleType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
