// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.UpdateResourceResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateResourceOperationDeserializer: HttpDeserialize<UpdateResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateResourceResponse {
        if (!response.status.isSuccess()) {
            throwUpdateResourceError(context, response)
        }
        val builder = UpdateResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectoryUnavailableException" -> DirectoryUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "EmailAddressInUseException" -> EmailAddressInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityStateException" -> EntityStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConfigurationException" -> InvalidConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "MailDomainNotFoundException" -> MailDomainNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "MailDomainStateException" -> MailDomainStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NameAvailabilityException" -> NameAvailabilityExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
