// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.TestAvailabilityConfigurationResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestAvailabilityConfigurationOperationDeserializer: HttpDeserialize<TestAvailabilityConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TestAvailabilityConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwTestAvailabilityConfigurationError(context, response)
        }
        val builder = TestAvailabilityConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTestAvailabilityConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwTestAvailabilityConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestAvailabilityConfigurationOperationBody(builder: TestAvailabilityConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val TESTPASSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TestPassed"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILUREREASON_DESCRIPTOR)
        field(TESTPASSED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                TESTPASSED_DESCRIPTOR.index -> builder.testPassed = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
