// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.GetMobileDeviceAccessOverrideResponse
import aws.sdk.kotlin.services.workmail.model.MobileDeviceAccessRuleEffect
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetMobileDeviceAccessOverrideOperationDeserializer: HttpDeserialize<GetMobileDeviceAccessOverrideResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMobileDeviceAccessOverrideResponse {
        if (!response.status.isSuccess()) {
            throwGetMobileDeviceAccessOverrideError(context, response)
        }
        val builder = GetMobileDeviceAccessOverrideResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMobileDeviceAccessOverrideOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMobileDeviceAccessOverrideError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMobileDeviceAccessOverrideOperationBody(builder: GetMobileDeviceAccessOverrideResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateCreated"))
    val DATEMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DateModified"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceId"))
    val EFFECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Effect"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATECREATED_DESCRIPTOR)
        field(DATEMODIFIED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEID_DESCRIPTOR)
        field(EFFECT_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATEMODIFIED_DESCRIPTOR.index -> builder.dateModified = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DEVICEID_DESCRIPTOR.index -> builder.deviceId = deserializeString()
                EFFECT_DESCRIPTOR.index -> builder.effect = deserializeString().let { MobileDeviceAccessRuleEffect.fromValue(it) }
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
