// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.GetMailboxDetailsResponse
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMailboxDetailsOperationDeserializer: HttpDeserialize<GetMailboxDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMailboxDetailsResponse {
        if (!response.status.isSuccess()) {
            throwGetMailboxDetailsError(context, response)
        }
        val builder = GetMailboxDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMailboxDetailsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMailboxDetailsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMailboxDetailsOperationBody(builder: GetMailboxDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MAILBOXQUOTA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MailboxQuota"))
    val MAILBOXSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("MailboxSize"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAILBOXQUOTA_DESCRIPTOR)
        field(MAILBOXSIZE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MAILBOXQUOTA_DESCRIPTOR.index -> builder.mailboxQuota = deserializeInt()
                MAILBOXSIZE_DESCRIPTOR.index -> builder.mailboxSize = deserializeDouble()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
