// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.transform

import aws.sdk.kotlin.services.workmail.model.AccessEffect
import aws.sdk.kotlin.services.workmail.model.GetImpersonationRoleEffectResponse
import aws.sdk.kotlin.services.workmail.model.ImpersonationMatchedRule
import aws.sdk.kotlin.services.workmail.model.ImpersonationRoleType
import aws.sdk.kotlin.services.workmail.model.WorkMailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetImpersonationRoleEffectOperationDeserializer: HttpDeserialize<GetImpersonationRoleEffectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetImpersonationRoleEffectResponse {
        if (!response.status.isSuccess()) {
            throwGetImpersonationRoleEffectError(context, response)
        }
        val builder = GetImpersonationRoleEffectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetImpersonationRoleEffectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetImpersonationRoleEffectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkMailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityStateException" -> EntityStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotFoundException" -> OrganizationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationStateException" -> OrganizationStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkMailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetImpersonationRoleEffectOperationBody(builder: GetImpersonationRoleEffectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EFFECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Effect"))
    val MATCHEDRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MatchedRules"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EFFECT_DESCRIPTOR)
        field(MATCHEDRULES_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EFFECT_DESCRIPTOR.index -> builder.effect = deserializeString().let { AccessEffect.fromValue(it) }
                MATCHEDRULES_DESCRIPTOR.index -> builder.matchedRules =
                    deserializer.deserializeList(MATCHEDRULES_DESCRIPTOR) {
                        val col0 = mutableListOf<ImpersonationMatchedRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImpersonationMatchedRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ImpersonationRoleType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
