// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.paginators

import aws.sdk.kotlin.services.workmail.WorkMailClient
import aws.sdk.kotlin.services.workmail.model.AvailabilityConfiguration
import aws.sdk.kotlin.services.workmail.model.ListAliasesRequest
import aws.sdk.kotlin.services.workmail.model.ListAliasesResponse
import aws.sdk.kotlin.services.workmail.model.ListAvailabilityConfigurationsRequest
import aws.sdk.kotlin.services.workmail.model.ListAvailabilityConfigurationsResponse
import aws.sdk.kotlin.services.workmail.model.ListGroupMembersRequest
import aws.sdk.kotlin.services.workmail.model.ListGroupMembersResponse
import aws.sdk.kotlin.services.workmail.model.ListGroupsRequest
import aws.sdk.kotlin.services.workmail.model.ListGroupsResponse
import aws.sdk.kotlin.services.workmail.model.ListImpersonationRolesRequest
import aws.sdk.kotlin.services.workmail.model.ListImpersonationRolesResponse
import aws.sdk.kotlin.services.workmail.model.ListMailDomainsRequest
import aws.sdk.kotlin.services.workmail.model.ListMailDomainsResponse
import aws.sdk.kotlin.services.workmail.model.ListMailboxExportJobsRequest
import aws.sdk.kotlin.services.workmail.model.ListMailboxExportJobsResponse
import aws.sdk.kotlin.services.workmail.model.ListMailboxPermissionsRequest
import aws.sdk.kotlin.services.workmail.model.ListMailboxPermissionsResponse
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessOverridesRequest
import aws.sdk.kotlin.services.workmail.model.ListMobileDeviceAccessOverridesResponse
import aws.sdk.kotlin.services.workmail.model.ListOrganizationsRequest
import aws.sdk.kotlin.services.workmail.model.ListOrganizationsResponse
import aws.sdk.kotlin.services.workmail.model.ListResourceDelegatesRequest
import aws.sdk.kotlin.services.workmail.model.ListResourceDelegatesResponse
import aws.sdk.kotlin.services.workmail.model.ListResourcesRequest
import aws.sdk.kotlin.services.workmail.model.ListResourcesResponse
import aws.sdk.kotlin.services.workmail.model.ListUsersRequest
import aws.sdk.kotlin.services.workmail.model.ListUsersResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun WorkMailClient.listAliasesPaginated(initialRequest: ListAliasesRequest): Flow<ListAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAliasesPaginated.listAliases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun WorkMailClient.listAliasesPaginated(block: ListAliasesRequest.Builder.() -> Unit): Flow<ListAliasesResponse> =
    listAliasesPaginated(ListAliasesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAvailabilityConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAvailabilityConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailabilityConfigurationsResponse]
 */
public fun WorkMailClient.listAvailabilityConfigurationsPaginated(initialRequest: ListAvailabilityConfigurationsRequest): Flow<ListAvailabilityConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAvailabilityConfigurationsPaginated.listAvailabilityConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAvailabilityConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailabilityConfigurationsResponse]
 */
public fun WorkMailClient.listAvailabilityConfigurationsPaginated(block: ListAvailabilityConfigurationsRequest.Builder.() -> Unit): Flow<ListAvailabilityConfigurationsResponse> =
    listAvailabilityConfigurationsPaginated(ListAvailabilityConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAvailabilityConfigurationsPaginated]
 * to access the nested member [AvailabilityConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AvailabilityConfiguration]
 */
@JvmName("listAvailabilityConfigurationsResponseAvailabilityConfiguration")
public fun Flow<ListAvailabilityConfigurationsResponse>.availabilityConfigurations(): Flow<AvailabilityConfiguration> =
    transform() { response ->
        response.availabilityConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembersResponse]
 */
public fun WorkMailClient.listGroupMembersPaginated(initialRequest: ListGroupMembersRequest): Flow<ListGroupMembersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupMembersPaginated.listGroupMembers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembersResponse]
 */
public fun WorkMailClient.listGroupMembersPaginated(block: ListGroupMembersRequest.Builder.() -> Unit): Flow<ListGroupMembersResponse> =
    listGroupMembersPaginated(ListGroupMembersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun WorkMailClient.listGroupsPaginated(initialRequest: ListGroupsRequest): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun WorkMailClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImpersonationRolesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImpersonationRolesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImpersonationRolesResponse]
 */
public fun WorkMailClient.listImpersonationRolesPaginated(initialRequest: ListImpersonationRolesRequest): Flow<ListImpersonationRolesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImpersonationRolesPaginated.listImpersonationRoles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImpersonationRolesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImpersonationRolesResponse]
 */
public fun WorkMailClient.listImpersonationRolesPaginated(block: ListImpersonationRolesRequest.Builder.() -> Unit): Flow<ListImpersonationRolesResponse> =
    listImpersonationRolesPaginated(ListImpersonationRolesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMailboxExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMailboxExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMailboxExportJobsResponse]
 */
public fun WorkMailClient.listMailboxExportJobsPaginated(initialRequest: ListMailboxExportJobsRequest): Flow<ListMailboxExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMailboxExportJobsPaginated.listMailboxExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMailboxExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMailboxExportJobsResponse]
 */
public fun WorkMailClient.listMailboxExportJobsPaginated(block: ListMailboxExportJobsRequest.Builder.() -> Unit): Flow<ListMailboxExportJobsResponse> =
    listMailboxExportJobsPaginated(ListMailboxExportJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMailboxPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMailboxPermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMailboxPermissionsResponse]
 */
public fun WorkMailClient.listMailboxPermissionsPaginated(initialRequest: ListMailboxPermissionsRequest): Flow<ListMailboxPermissionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMailboxPermissionsPaginated.listMailboxPermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMailboxPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMailboxPermissionsResponse]
 */
public fun WorkMailClient.listMailboxPermissionsPaginated(block: ListMailboxPermissionsRequest.Builder.() -> Unit): Flow<ListMailboxPermissionsResponse> =
    listMailboxPermissionsPaginated(ListMailboxPermissionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMailDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMailDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMailDomainsResponse]
 */
public fun WorkMailClient.listMailDomainsPaginated(initialRequest: ListMailDomainsRequest): Flow<ListMailDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMailDomainsPaginated.listMailDomains(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMailDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMailDomainsResponse]
 */
public fun WorkMailClient.listMailDomainsPaginated(block: ListMailDomainsRequest.Builder.() -> Unit): Flow<ListMailDomainsResponse> =
    listMailDomainsPaginated(ListMailDomainsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMobileDeviceAccessOverridesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMobileDeviceAccessOverridesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMobileDeviceAccessOverridesResponse]
 */
public fun WorkMailClient.listMobileDeviceAccessOverridesPaginated(initialRequest: ListMobileDeviceAccessOverridesRequest): Flow<ListMobileDeviceAccessOverridesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMobileDeviceAccessOverridesPaginated.listMobileDeviceAccessOverrides(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMobileDeviceAccessOverridesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMobileDeviceAccessOverridesResponse]
 */
public fun WorkMailClient.listMobileDeviceAccessOverridesPaginated(block: ListMobileDeviceAccessOverridesRequest.Builder.() -> Unit): Flow<ListMobileDeviceAccessOverridesResponse> =
    listMobileDeviceAccessOverridesPaginated(ListMobileDeviceAccessOverridesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListOrganizationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationsResponse]
 */
public fun WorkMailClient.listOrganizationsPaginated(initialRequest: ListOrganizationsRequest): Flow<ListOrganizationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationsPaginated.listOrganizations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationsResponse]
 */
public fun WorkMailClient.listOrganizationsPaginated(block: ListOrganizationsRequest.Builder.() -> Unit): Flow<ListOrganizationsResponse> =
    listOrganizationsPaginated(ListOrganizationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResourceDelegatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceDelegatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceDelegatesResponse]
 */
public fun WorkMailClient.listResourceDelegatesPaginated(initialRequest: ListResourceDelegatesRequest): Flow<ListResourceDelegatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceDelegatesPaginated.listResourceDelegates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceDelegatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceDelegatesResponse]
 */
public fun WorkMailClient.listResourceDelegatesPaginated(block: ListResourceDelegatesRequest.Builder.() -> Unit): Flow<ListResourceDelegatesResponse> =
    listResourceDelegatesPaginated(ListResourceDelegatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesResponse]
 */
public fun WorkMailClient.listResourcesPaginated(initialRequest: ListResourcesRequest): Flow<ListResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourcesPaginated.listResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesResponse]
 */
public fun WorkMailClient.listResourcesPaginated(block: ListResourcesRequest.Builder.() -> Unit): Flow<ListResourcesResponse> =
    listResourcesPaginated(ListResourcesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun WorkMailClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun WorkMailClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())
