// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workmail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A rule that controls access to an WorkMail organization.
 */
public class AccessControlRule private constructor(builder: Builder) {
    /**
     * Access protocol actions to include in the rule. Valid values include `ActiveSync`, `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`, and `WebMail`.
     */
    public val actions: List<String>? = builder.actions
    /**
     * The date that the rule was created.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The date that the rule was modified.
     */
    public val dateModified: aws.smithy.kotlin.runtime.time.Instant? = builder.dateModified
    /**
     * The rule description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The rule effect.
     */
    public val effect: aws.sdk.kotlin.services.workmail.model.AccessControlRuleEffect? = builder.effect
    /**
     * Impersonation role IDs to include in the rule.
     */
    public val impersonationRoleIds: List<String>? = builder.impersonationRoleIds
    /**
     * IPv4 CIDR ranges to include in the rule.
     */
    public val ipRanges: List<String>? = builder.ipRanges
    /**
     * The rule name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Access protocol actions to exclude from the rule. Valid values include `ActiveSync`, `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`, and `WebMail`.
     */
    public val notActions: List<String>? = builder.notActions
    /**
     * Impersonation role IDs to exclude from the rule.
     */
    public val notImpersonationRoleIds: List<String>? = builder.notImpersonationRoleIds
    /**
     * IPv4 CIDR ranges to exclude from the rule.
     */
    public val notIpRanges: List<String>? = builder.notIpRanges
    /**
     * User IDs to exclude from the rule.
     */
    public val notUserIds: List<String>? = builder.notUserIds
    /**
     * User IDs to include in the rule.
     */
    public val userIds: List<String>? = builder.userIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workmail.model.AccessControlRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessControlRule(")
        append("actions=$actions,")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("description=$description,")
        append("effect=$effect,")
        append("impersonationRoleIds=$impersonationRoleIds,")
        append("ipRanges=$ipRanges,")
        append("name=$name,")
        append("notActions=$notActions,")
        append("notImpersonationRoleIds=$notImpersonationRoleIds,")
        append("notIpRanges=$notIpRanges,")
        append("notUserIds=$notUserIds,")
        append("userIds=$userIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (effect?.hashCode() ?: 0)
        result = 31 * result + (impersonationRoleIds?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notActions?.hashCode() ?: 0)
        result = 31 * result + (notImpersonationRoleIds?.hashCode() ?: 0)
        result = 31 * result + (notIpRanges?.hashCode() ?: 0)
        result = 31 * result + (notUserIds?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessControlRule

        if (actions != other.actions) return false
        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (description != other.description) return false
        if (effect != other.effect) return false
        if (impersonationRoleIds != other.impersonationRoleIds) return false
        if (ipRanges != other.ipRanges) return false
        if (name != other.name) return false
        if (notActions != other.notActions) return false
        if (notImpersonationRoleIds != other.notImpersonationRoleIds) return false
        if (notIpRanges != other.notIpRanges) return false
        if (notUserIds != other.notUserIds) return false
        if (userIds != other.userIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workmail.model.AccessControlRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Access protocol actions to include in the rule. Valid values include `ActiveSync`, `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`, and `WebMail`.
         */
        public var actions: List<String>? = null
        /**
         * The date that the rule was created.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date that the rule was modified.
         */
        public var dateModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The rule description.
         */
        public var description: kotlin.String? = null
        /**
         * The rule effect.
         */
        public var effect: aws.sdk.kotlin.services.workmail.model.AccessControlRuleEffect? = null
        /**
         * Impersonation role IDs to include in the rule.
         */
        public var impersonationRoleIds: List<String>? = null
        /**
         * IPv4 CIDR ranges to include in the rule.
         */
        public var ipRanges: List<String>? = null
        /**
         * The rule name.
         */
        public var name: kotlin.String? = null
        /**
         * Access protocol actions to exclude from the rule. Valid values include `ActiveSync`, `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`, and `WebMail`.
         */
        public var notActions: List<String>? = null
        /**
         * Impersonation role IDs to exclude from the rule.
         */
        public var notImpersonationRoleIds: List<String>? = null
        /**
         * IPv4 CIDR ranges to exclude from the rule.
         */
        public var notIpRanges: List<String>? = null
        /**
         * User IDs to exclude from the rule.
         */
        public var notUserIds: List<String>? = null
        /**
         * User IDs to include in the rule.
         */
        public var userIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workmail.model.AccessControlRule) : this() {
            this.actions = x.actions
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.description = x.description
            this.effect = x.effect
            this.impersonationRoleIds = x.impersonationRoleIds
            this.ipRanges = x.ipRanges
            this.name = x.name
            this.notActions = x.notActions
            this.notImpersonationRoleIds = x.notImpersonationRoleIds
            this.notIpRanges = x.notIpRanges
            this.notUserIds = x.notUserIds
            this.userIds = x.userIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workmail.model.AccessControlRule = AccessControlRule(this)
    }
}
