// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink.serde

import aws.sdk.kotlin.services.worklink.model.DescribeFleetMetadataResponse
import aws.sdk.kotlin.services.worklink.model.FleetStatus
import aws.sdk.kotlin.services.worklink.model.WorkLinkException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class DescribeFleetMetadataOperationDeserializer: HttpDeserialize<DescribeFleetMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeFleetMetadataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFleetMetadataError(context, call)
        }
        val builder = DescribeFleetMetadataResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFleetMetadataOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeFleetMetadataError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkLinkException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkLinkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFleetMetadataOperationBody(builder: DescribeFleetMetadataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPANYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CompanyCode"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val FLEETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetName"))
    val FLEETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FleetStatus"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val OPTIMIZEFORENDUSERLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("OptimizeForEndUserLocation"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPANYCODE_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(FLEETNAME_DESCRIPTOR)
        field(FLEETSTATUS_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(OPTIMIZEFORENDUSERLOCATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPANYCODE_DESCRIPTOR.index -> builder.companyCode = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                FLEETNAME_DESCRIPTOR.index -> builder.fleetName = deserializeString()
                FLEETSTATUS_DESCRIPTOR.index -> builder.fleetStatus = deserializeString().let { FleetStatus.fromValue(it) }
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                OPTIMIZEFORENDUSERLOCATION_DESCRIPTOR.index -> builder.optimizeForEndUserLocation = deserializeBoolean()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
