// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink.serde

import aws.sdk.kotlin.services.worklink.model.DescribeDomainResponse
import aws.sdk.kotlin.services.worklink.model.DomainStatus
import aws.sdk.kotlin.services.worklink.model.WorkLinkException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDomainOperationDeserializer: HttpDeserialize<DescribeDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDomainError(context, call)
        }
        val builder = DescribeDomainResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDomainOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDomainError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkLinkException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkLinkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDomainOperationBody(builder: DescribeDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACMCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AcmCertificateArn"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val DOMAINSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DomainStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACMCERTIFICATEARN_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACMCERTIFICATEARN_DESCRIPTOR.index -> builder.acmCertificateArn = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                DOMAINSTATUS_DESCRIPTOR.index -> builder.domainStatus = deserializeString().let { DomainStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
