// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink.serde

import aws.sdk.kotlin.services.worklink.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.worklink.model.DeviceStatus
import aws.sdk.kotlin.services.worklink.model.WorkLinkException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDeviceOperationDeserializer: HttpDeserialize<DescribeDeviceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDeviceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDeviceError(context, call)
        }
        val builder = DescribeDeviceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDeviceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDeviceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkLinkException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkLinkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDeviceOperationBody(builder: DescribeDeviceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FIRSTACCESSEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("FirstAccessedTime"))
    val LASTACCESSEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastAccessedTime"))
    val MANUFACTURER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Manufacturer"))
    val MODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Model"))
    val OPERATINGSYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperatingSystem"))
    val OPERATINGSYSTEMVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperatingSystemVersion"))
    val PATCHLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PatchLevel"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FIRSTACCESSEDTIME_DESCRIPTOR)
        field(LASTACCESSEDTIME_DESCRIPTOR)
        field(MANUFACTURER_DESCRIPTOR)
        field(MODEL_DESCRIPTOR)
        field(OPERATINGSYSTEM_DESCRIPTOR)
        field(OPERATINGSYSTEMVERSION_DESCRIPTOR)
        field(PATCHLEVEL_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FIRSTACCESSEDTIME_DESCRIPTOR.index -> builder.firstAccessedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTACCESSEDTIME_DESCRIPTOR.index -> builder.lastAccessedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MANUFACTURER_DESCRIPTOR.index -> builder.manufacturer = deserializeString()
                MODEL_DESCRIPTOR.index -> builder.model = deserializeString()
                OPERATINGSYSTEM_DESCRIPTOR.index -> builder.operatingSystem = deserializeString()
                OPERATINGSYSTEMVERSION_DESCRIPTOR.index -> builder.operatingSystemVersion = deserializeString()
                PATCHLEVEL_DESCRIPTOR.index -> builder.patchLevel = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DeviceStatus.fromValue(it) }
                USERNAME_DESCRIPTOR.index -> builder.username = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
