// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink.paginators

import aws.sdk.kotlin.services.worklink.WorkLinkClient
import aws.sdk.kotlin.services.worklink.model.ListDevicesRequest
import aws.sdk.kotlin.services.worklink.model.ListDevicesResponse
import aws.sdk.kotlin.services.worklink.model.ListDomainsRequest
import aws.sdk.kotlin.services.worklink.model.ListDomainsResponse
import aws.sdk.kotlin.services.worklink.model.ListFleetsRequest
import aws.sdk.kotlin.services.worklink.model.ListFleetsResponse
import aws.sdk.kotlin.services.worklink.model.ListWebsiteAuthorizationProvidersRequest
import aws.sdk.kotlin.services.worklink.model.ListWebsiteAuthorizationProvidersResponse
import aws.sdk.kotlin.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest
import aws.sdk.kotlin.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicesResponse]
 */
public fun WorkLinkClient.listDevicesPaginated(initialRequest: ListDevicesRequest): Flow<ListDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDevicesPaginated.listDevices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicesResponse]
 */
public fun WorkLinkClient.listDevicesPaginated(block: ListDevicesRequest.Builder.() -> Unit): Flow<ListDevicesResponse> =
    listDevicesPaginated(ListDevicesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun WorkLinkClient.listDomainsPaginated(initialRequest: ListDomainsRequest): Flow<ListDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsPaginated.listDomains(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun WorkLinkClient.listDomainsPaginated(block: ListDomainsRequest.Builder.() -> Unit): Flow<ListDomainsResponse> =
    listDomainsPaginated(ListDomainsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFleetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun WorkLinkClient.listFleetsPaginated(initialRequest: ListFleetsRequest): Flow<ListFleetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFleetsPaginated.listFleets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun WorkLinkClient.listFleetsPaginated(block: ListFleetsRequest.Builder.() -> Unit): Flow<ListFleetsResponse> =
    listFleetsPaginated(ListFleetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWebsiteAuthorizationProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWebsiteAuthorizationProvidersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebsiteAuthorizationProvidersResponse]
 */
public fun WorkLinkClient.listWebsiteAuthorizationProvidersPaginated(initialRequest: ListWebsiteAuthorizationProvidersRequest): Flow<ListWebsiteAuthorizationProvidersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWebsiteAuthorizationProvidersPaginated.listWebsiteAuthorizationProviders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWebsiteAuthorizationProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebsiteAuthorizationProvidersResponse]
 */
public fun WorkLinkClient.listWebsiteAuthorizationProvidersPaginated(block: ListWebsiteAuthorizationProvidersRequest.Builder.() -> Unit): Flow<ListWebsiteAuthorizationProvidersResponse> =
    listWebsiteAuthorizationProvidersPaginated(ListWebsiteAuthorizationProvidersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWebsiteCertificateAuthoritiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWebsiteCertificateAuthoritiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebsiteCertificateAuthoritiesResponse]
 */
public fun WorkLinkClient.listWebsiteCertificateAuthoritiesPaginated(initialRequest: ListWebsiteCertificateAuthoritiesRequest): Flow<ListWebsiteCertificateAuthoritiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWebsiteCertificateAuthoritiesPaginated.listWebsiteCertificateAuthorities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWebsiteCertificateAuthoritiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebsiteCertificateAuthoritiesResponse]
 */
public fun WorkLinkClient.listWebsiteCertificateAuthoritiesPaginated(block: ListWebsiteCertificateAuthoritiesRequest.Builder.() -> Unit): Flow<ListWebsiteCertificateAuthoritiesResponse> =
    listWebsiteCertificateAuthoritiesPaginated(ListWebsiteCertificateAuthoritiesRequest.Builder().apply(block).build())
