// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.worklink

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.worklink.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.worklink.endpoints.EndpointParameters
import aws.sdk.kotlin.services.worklink.endpoints.EndpointProvider
import aws.sdk.kotlin.services.worklink.model.AssociateDomainRequest
import aws.sdk.kotlin.services.worklink.model.AssociateDomainResponse
import aws.sdk.kotlin.services.worklink.model.AssociateWebsiteAuthorizationProviderRequest
import aws.sdk.kotlin.services.worklink.model.AssociateWebsiteAuthorizationProviderResponse
import aws.sdk.kotlin.services.worklink.model.AssociateWebsiteCertificateAuthorityRequest
import aws.sdk.kotlin.services.worklink.model.AssociateWebsiteCertificateAuthorityResponse
import aws.sdk.kotlin.services.worklink.model.CreateFleetRequest
import aws.sdk.kotlin.services.worklink.model.CreateFleetResponse
import aws.sdk.kotlin.services.worklink.model.DeleteFleetRequest
import aws.sdk.kotlin.services.worklink.model.DeleteFleetResponse
import aws.sdk.kotlin.services.worklink.model.DescribeAuditStreamConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.DescribeAuditStreamConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.DescribeCompanyNetworkConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.DescribeCompanyNetworkConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.DescribeDevicePolicyConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.DescribeDevicePolicyConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.DescribeDeviceRequest
import aws.sdk.kotlin.services.worklink.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.worklink.model.DescribeDomainRequest
import aws.sdk.kotlin.services.worklink.model.DescribeDomainResponse
import aws.sdk.kotlin.services.worklink.model.DescribeFleetMetadataRequest
import aws.sdk.kotlin.services.worklink.model.DescribeFleetMetadataResponse
import aws.sdk.kotlin.services.worklink.model.DescribeIdentityProviderConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.DescribeIdentityProviderConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.DescribeWebsiteCertificateAuthorityRequest
import aws.sdk.kotlin.services.worklink.model.DescribeWebsiteCertificateAuthorityResponse
import aws.sdk.kotlin.services.worklink.model.DisassociateDomainRequest
import aws.sdk.kotlin.services.worklink.model.DisassociateDomainResponse
import aws.sdk.kotlin.services.worklink.model.DisassociateWebsiteAuthorizationProviderRequest
import aws.sdk.kotlin.services.worklink.model.DisassociateWebsiteAuthorizationProviderResponse
import aws.sdk.kotlin.services.worklink.model.DisassociateWebsiteCertificateAuthorityRequest
import aws.sdk.kotlin.services.worklink.model.DisassociateWebsiteCertificateAuthorityResponse
import aws.sdk.kotlin.services.worklink.model.ListDevicesRequest
import aws.sdk.kotlin.services.worklink.model.ListDevicesResponse
import aws.sdk.kotlin.services.worklink.model.ListDomainsRequest
import aws.sdk.kotlin.services.worklink.model.ListDomainsResponse
import aws.sdk.kotlin.services.worklink.model.ListFleetsRequest
import aws.sdk.kotlin.services.worklink.model.ListFleetsResponse
import aws.sdk.kotlin.services.worklink.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.worklink.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.worklink.model.ListWebsiteAuthorizationProvidersRequest
import aws.sdk.kotlin.services.worklink.model.ListWebsiteAuthorizationProvidersResponse
import aws.sdk.kotlin.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest
import aws.sdk.kotlin.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse
import aws.sdk.kotlin.services.worklink.model.RestoreDomainAccessRequest
import aws.sdk.kotlin.services.worklink.model.RestoreDomainAccessResponse
import aws.sdk.kotlin.services.worklink.model.RevokeDomainAccessRequest
import aws.sdk.kotlin.services.worklink.model.RevokeDomainAccessResponse
import aws.sdk.kotlin.services.worklink.model.SignOutUserRequest
import aws.sdk.kotlin.services.worklink.model.SignOutUserResponse
import aws.sdk.kotlin.services.worklink.model.TagResourceRequest
import aws.sdk.kotlin.services.worklink.model.TagResourceResponse
import aws.sdk.kotlin.services.worklink.model.UntagResourceRequest
import aws.sdk.kotlin.services.worklink.model.UntagResourceResponse
import aws.sdk.kotlin.services.worklink.model.UpdateAuditStreamConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.UpdateAuditStreamConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.UpdateCompanyNetworkConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.UpdateCompanyNetworkConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.UpdateDevicePolicyConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.UpdateDevicePolicyConfigurationResponse
import aws.sdk.kotlin.services.worklink.model.UpdateDomainMetadataRequest
import aws.sdk.kotlin.services.worklink.model.UpdateDomainMetadataResponse
import aws.sdk.kotlin.services.worklink.model.UpdateFleetMetadataRequest
import aws.sdk.kotlin.services.worklink.model.UpdateFleetMetadataResponse
import aws.sdk.kotlin.services.worklink.model.UpdateIdentityProviderConfigurationRequest
import aws.sdk.kotlin.services.worklink.model.UpdateIdentityProviderConfigurationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "WorkLink"
public const val SdkVersion: String = "0.29.0-beta"

/**
 * Amazon WorkLink is a cloud-based service that provides secure access to internal websites and web apps from iOS and Android phones. In a single step, your users, such as employees, can access internal websites as efficiently as they access any other public website. They enter a URL in their web browser, or choose a link to an internal website in an email. Amazon WorkLink authenticates the user's access and securely renders authorized internal web content in a secure rendering service in the AWS cloud. Amazon WorkLink doesn't download or store any internal web content on mobile devices.
 */
public interface WorkLinkClient : SdkClient {
    /**
     * WorkLinkClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WorkLinkClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WorkLinkClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WorkLinkClient = DefaultWorkLinkClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WorkLink"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Specifies a domain to be associated to Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun associateDomain(input: AssociateDomainRequest): AssociateDomainResponse

    /**
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun associateWebsiteAuthorizationProvider(input: AssociateWebsiteAuthorizationProviderRequest): AssociateWebsiteAuthorizationProviderResponse

    /**
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun associateWebsiteCertificateAuthority(input: AssociateWebsiteCertificateAuthorityRequest): AssociateWebsiteCertificateAuthorityResponse

    /**
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Describes the configuration for delivering audit streams to the customer account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeAuditStreamConfiguration(input: DescribeAuditStreamConfigurationRequest): DescribeAuditStreamConfigurationResponse

    /**
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeCompanyNetworkConfiguration(input: DescribeCompanyNetworkConfigurationRequest): DescribeCompanyNetworkConfigurationResponse

    /**
     * Provides information about a user's device.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Describes the device policy configuration for the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeDevicePolicyConfiguration(input: DescribeDevicePolicyConfigurationRequest): DescribeDevicePolicyConfigurationResponse

    /**
     * Provides information about the domain.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeFleetMetadata(input: DescribeFleetMetadataRequest): DescribeFleetMetadataResponse

    /**
     * Describes the identity provider configuration of the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeIdentityProviderConfiguration(input: DescribeIdentityProviderConfigurationRequest): DescribeIdentityProviderConfigurationResponse

    /**
     * Provides information about the certificate authority.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeWebsiteCertificateAuthority(input: DescribeWebsiteCertificateAuthorityRequest): DescribeWebsiteCertificateAuthorityResponse

    /**
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun disassociateDomain(input: DisassociateDomainRequest): DisassociateDomainResponse

    /**
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun disassociateWebsiteAuthorizationProvider(input: DisassociateWebsiteAuthorizationProviderRequest): DisassociateWebsiteAuthorizationProviderResponse

    /**
     * Removes a certificate authority (CA).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun disassociateWebsiteCertificateAuthority(input: DisassociateWebsiteCertificateAuthorityRequest): DisassociateWebsiteCertificateAuthorityResponse

    /**
     * Retrieves a list of devices registered with the specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse

    /**
     * Retrieves a list of domains associated to a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse

    /**
     * Retrieves a list of fleets for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest {}): ListFleetsResponse

    /**
     * Retrieves a list of tags for the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of website authorization providers associated with a specified fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listWebsiteAuthorizationProviders(input: ListWebsiteAuthorizationProvidersRequest): ListWebsiteAuthorizationProvidersResponse

    /**
     * Retrieves a list of certificate authorities added for the current account and Region.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listWebsiteCertificateAuthorities(input: ListWebsiteCertificateAuthoritiesRequest): ListWebsiteCertificateAuthoritiesResponse

    /**
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun restoreDomainAccess(input: RestoreDomainAccessRequest): RestoreDomainAccessResponse

    /**
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun revokeDomainAccess(input: RevokeDomainAccessRequest): RevokeDomainAccessResponse

    /**
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun signOutUser(input: SignOutUserRequest): SignOutUserResponse

    /**
     * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the audit stream configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateAuditStreamConfiguration(input: UpdateAuditStreamConfigurationRequest): UpdateAuditStreamConfigurationResponse

    /**
     * Updates the company network configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateCompanyNetworkConfiguration(input: UpdateCompanyNetworkConfigurationRequest): UpdateCompanyNetworkConfigurationResponse

    /**
     * Updates the device policy configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateDevicePolicyConfiguration(input: UpdateDevicePolicyConfigurationRequest): UpdateDevicePolicyConfigurationResponse

    /**
     * Updates domain metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateDomainMetadata(input: UpdateDomainMetadataRequest): UpdateDomainMetadataResponse

    /**
     * Updates fleet metadata, such as DisplayName.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateFleetMetadata(input: UpdateFleetMetadataRequest): UpdateFleetMetadataResponse

    /**
     * Updates the identity provider configuration for the fleet.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateIdentityProviderConfiguration(input: UpdateIdentityProviderConfigurationRequest): UpdateIdentityProviderConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WorkLinkClient.withConfig(block: WorkLinkClient.Config.Builder.() -> Unit): WorkLinkClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWorkLinkClient(newConfig)
}

/**
 * Specifies a domain to be associated to Amazon WorkLink.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.associateDomain(crossinline block: AssociateDomainRequest.Builder.() -> Unit): AssociateDomainResponse = associateDomain(AssociateDomainRequest.Builder().apply(block).build())

/**
 * Associates a website authorization provider with a specified fleet. This is used to authorize users against associated websites in the company network.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.associateWebsiteAuthorizationProvider(crossinline block: AssociateWebsiteAuthorizationProviderRequest.Builder.() -> Unit): AssociateWebsiteAuthorizationProviderResponse = associateWebsiteAuthorizationProvider(AssociateWebsiteAuthorizationProviderRequest.Builder().apply(block).build())

/**
 * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated websites within the company network.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.associateWebsiteCertificateAuthority(crossinline block: AssociateWebsiteCertificateAuthorityRequest.Builder.() -> Unit): AssociateWebsiteCertificateAuthorityResponse = associateWebsiteCertificateAuthority(AssociateWebsiteCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to authorized users who download and set up the Amazon WorkLink app.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Deletes a fleet. Prevents users from accessing previously associated websites.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Describes the configuration for delivering audit streams to the customer account.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeAuditStreamConfiguration(crossinline block: DescribeAuditStreamConfigurationRequest.Builder.() -> Unit): DescribeAuditStreamConfigurationResponse = describeAuditStreamConfiguration(DescribeAuditStreamConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the networking configuration to access the internal websites associated with the specified fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeCompanyNetworkConfiguration(crossinline block: DescribeCompanyNetworkConfigurationRequest.Builder.() -> Unit): DescribeCompanyNetworkConfigurationResponse = describeCompanyNetworkConfiguration(DescribeCompanyNetworkConfigurationRequest.Builder().apply(block).build())

/**
 * Provides information about a user's device.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeDevice(crossinline block: DescribeDeviceRequest.Builder.() -> Unit): DescribeDeviceResponse = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

/**
 * Describes the device policy configuration for the specified fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeDevicePolicyConfiguration(crossinline block: DescribeDevicePolicyConfigurationRequest.Builder.() -> Unit): DescribeDevicePolicyConfigurationResponse = describeDevicePolicyConfiguration(DescribeDevicePolicyConfigurationRequest.Builder().apply(block).build())

/**
 * Provides information about the domain.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeDomain(crossinline block: DescribeDomainRequest.Builder.() -> Unit): DescribeDomainResponse = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

/**
 * Provides basic information for the specified fleet, excluding identity provider, networking, and device configuration details.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeFleetMetadata(crossinline block: DescribeFleetMetadataRequest.Builder.() -> Unit): DescribeFleetMetadataResponse = describeFleetMetadata(DescribeFleetMetadataRequest.Builder().apply(block).build())

/**
 * Describes the identity provider configuration of the specified fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeIdentityProviderConfiguration(crossinline block: DescribeIdentityProviderConfigurationRequest.Builder.() -> Unit): DescribeIdentityProviderConfigurationResponse = describeIdentityProviderConfiguration(DescribeIdentityProviderConfigurationRequest.Builder().apply(block).build())

/**
 * Provides information about the certificate authority.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.describeWebsiteCertificateAuthority(crossinline block: DescribeWebsiteCertificateAuthorityRequest.Builder.() -> Unit): DescribeWebsiteCertificateAuthorityResponse = describeWebsiteCertificateAuthority(DescribeWebsiteCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon WorkLink.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.disassociateDomain(crossinline block: DisassociateDomainRequest.Builder.() -> Unit): DisassociateDomainResponse = disassociateDomain(DisassociateDomainRequest.Builder().apply(block).build())

/**
 * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load any associated websites that require this authorization provider.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.disassociateWebsiteAuthorizationProvider(crossinline block: DisassociateWebsiteAuthorizationProviderRequest.Builder.() -> Unit): DisassociateWebsiteAuthorizationProviderResponse = disassociateWebsiteAuthorizationProvider(DisassociateWebsiteAuthorizationProviderRequest.Builder().apply(block).build())

/**
 * Removes a certificate authority (CA).
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.disassociateWebsiteCertificateAuthority(crossinline block: DisassociateWebsiteCertificateAuthorityRequest.Builder.() -> Unit): DisassociateWebsiteCertificateAuthorityResponse = disassociateWebsiteCertificateAuthority(DisassociateWebsiteCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Retrieves a list of devices registered with the specified fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.listDevices(crossinline block: ListDevicesRequest.Builder.() -> Unit): ListDevicesResponse = listDevices(ListDevicesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of domains associated to a specified fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of fleets for the current account and Region.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.listFleets(crossinline block: ListFleetsRequest.Builder.() -> Unit): ListFleetsResponse = listFleets(ListFleetsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of tags for the specified resource.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of website authorization providers associated with a specified fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.listWebsiteAuthorizationProviders(crossinline block: ListWebsiteAuthorizationProvidersRequest.Builder.() -> Unit): ListWebsiteAuthorizationProvidersResponse = listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersRequest.Builder().apply(block).build())

/**
 * Retrieves a list of certificate authorities added for the current account and Region.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.listWebsiteCertificateAuthorities(crossinline block: ListWebsiteCertificateAuthoritiesRequest.Builder.() -> Unit): ListWebsiteCertificateAuthoritiesResponse = listWebsiteCertificateAuthorities(ListWebsiteCertificateAuthoritiesRequest.Builder().apply(block).build())

/**
 * Moves a domain to ACTIVE status if it was in the INACTIVE status.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.restoreDomainAccess(crossinline block: RestoreDomainAccessRequest.Builder.() -> Unit): RestoreDomainAccessResponse = restoreDomainAccess(RestoreDomainAccessRequest.Builder().apply(block).build())

/**
 * Moves a domain to INACTIVE status if it was in the ACTIVE status.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.revokeDomainAccess(crossinline block: RevokeDomainAccessRequest.Builder.() -> Unit): RevokeDomainAccessResponse = revokeDomainAccess(RevokeDomainAccessRequest.Builder().apply(block).build())

/**
 * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.signOutUser(crossinline block: SignOutUserRequest.Builder.() -> Unit): SignOutUserResponse = signOutUser(SignOutUserRequest.Builder().apply(block).build())

/**
 * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the audit stream configuration for the fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.updateAuditStreamConfiguration(crossinline block: UpdateAuditStreamConfigurationRequest.Builder.() -> Unit): UpdateAuditStreamConfigurationResponse = updateAuditStreamConfiguration(UpdateAuditStreamConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the company network configuration for the fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.updateCompanyNetworkConfiguration(crossinline block: UpdateCompanyNetworkConfigurationRequest.Builder.() -> Unit): UpdateCompanyNetworkConfigurationResponse = updateCompanyNetworkConfiguration(UpdateCompanyNetworkConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the device policy configuration for the fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.updateDevicePolicyConfiguration(crossinline block: UpdateDevicePolicyConfigurationRequest.Builder.() -> Unit): UpdateDevicePolicyConfigurationResponse = updateDevicePolicyConfiguration(UpdateDevicePolicyConfigurationRequest.Builder().apply(block).build())

/**
 * Updates domain metadata, such as DisplayName.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.updateDomainMetadata(crossinline block: UpdateDomainMetadataRequest.Builder.() -> Unit): UpdateDomainMetadataResponse = updateDomainMetadata(UpdateDomainMetadataRequest.Builder().apply(block).build())

/**
 * Updates fleet metadata, such as DisplayName.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.updateFleetMetadata(crossinline block: UpdateFleetMetadataRequest.Builder.() -> Unit): UpdateFleetMetadataResponse = updateFleetMetadata(UpdateFleetMetadataRequest.Builder().apply(block).build())

/**
 * Updates the identity provider configuration for the fleet.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun WorkLinkClient.updateIdentityProviderConfiguration(crossinline block: UpdateIdentityProviderConfigurationRequest.Builder.() -> Unit): UpdateIdentityProviderConfigurationResponse = updateIdentityProviderConfiguration(UpdateIdentityProviderConfigurationRequest.Builder().apply(block).build())
