// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.DocumentMetadata
import aws.sdk.kotlin.services.workdocs.model.GetDocumentResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetDocumentOperationDeserializer: HttpDeserializer.NonStreaming<GetDocumentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDocumentError(context, call, payload)
        }
        val builder = GetDocumentResponse.Builder()

        if (payload != null) {
            deserializeGetDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDocumentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidPasswordException" -> InvalidPasswordExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkDocsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDocumentOperationBody(builder: GetDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("CustomMetadata"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Metadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMMETADATA_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMMETADATA_DESCRIPTOR.index -> builder.customMetadata =
                    deserializer.deserializeMap(CUSTOMMETADATA_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeDocumentMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
