// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.InitiateDocumentVersionUploadRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class InitiateDocumentVersionUploadOperationSerializer: HttpSerializer.NonStreaming<InitiateDocumentVersionUploadRequest> {
    override fun serialize(context: ExecutionContext, input: InitiateDocumentVersionUploadRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/api/v1/documents"
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        val payload = serializeInitiateDocumentVersionUploadOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeInitiateDocumentVersionUploadOperationBody(context: ExecutionContext, input: InitiateDocumentVersionUploadRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTCREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ContentCreatedTimestamp"))
    val CONTENTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ContentModifiedTimestamp"))
    val CONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContentType"))
    val DOCUMENTSIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("DocumentSizeInBytes"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARENTFOLDERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ParentFolderId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTCREATEDTIMESTAMP_DESCRIPTOR)
        field(CONTENTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(CONTENTTYPE_DESCRIPTOR)
        field(DOCUMENTSIZEINBYTES_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARENTFOLDERID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contentCreatedTimestamp?.let { field(CONTENTCREATEDTIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.contentModifiedTimestamp?.let { field(CONTENTMODIFIEDTIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.contentType?.let { field(CONTENTTYPE_DESCRIPTOR, it) }
        input.documentSizeInBytes?.let { field(DOCUMENTSIZEINBYTES_DESCRIPTOR, it) }
        input.id?.let { field(ID_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parentFolderId?.let { field(PARENTFOLDERID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
