// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.DocumentVersionStatus
import aws.sdk.kotlin.services.workdocs.model.UpdateDocumentVersionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDocumentVersionOperationSerializer: HttpSerializer.NonStreaming<UpdateDocumentVersionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDocumentVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.documentId) { "documentId is bound to the URI and must not be null" }
            requireNotNull(input.versionId) { "versionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("api"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("documents"))
                add(PercentEncoding.SmithyLabel.encode(input.documentId))
                add(PercentEncoding.Path.encode("versions"))
                add(PercentEncoding.SmithyLabel.encode(input.versionId))
            }
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        val payload = serializeUpdateDocumentVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDocumentVersionOperationBody(context: ExecutionContext, input: UpdateDocumentVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val VERSIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VersionStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VERSIONSTATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.versionStatus?.let { field(VERSIONSTATUS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
