// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.GetDocumentPathRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class GetDocumentPathOperationSerializer: HttpSerializer.NonStreaming<GetDocumentPathRequest> {
    override fun serialize(context: ExecutionContext, input: GetDocumentPathRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.documentId) { "documentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("api"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("documents"))
                add(PercentEncoding.SmithyLabel.encode(input.documentId))
                add(PercentEncoding.Path.encode("path"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.fields != null) add("fields", input.fields)
                if (input.limit != null) add("limit", input.limit.toString())
                if (input.marker != null) add("marker", input.marker)
            }
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        return builder
    }
}
