// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.AddResourcePermissionsRequest
import aws.sdk.kotlin.services.workdocs.model.NotificationOptions
import aws.sdk.kotlin.services.workdocs.model.SharePrincipal
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AddResourcePermissionsOperationSerializer: HttpSerializer.NonStreaming<AddResourcePermissionsRequest> {
    override fun serialize(context: ExecutionContext, input: AddResourcePermissionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.resourceId) { "resourceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("api"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("resources"))
                add(PercentEncoding.SmithyLabel.encode(input.resourceId))
                add(PercentEncoding.Path.encode("permissions"))
            }
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        val payload = serializeAddResourcePermissionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAddResourcePermissionsOperationBody(context: ExecutionContext, input: AddResourcePermissionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val NOTIFICATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NotificationOptions"))
    val PRINCIPALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Principals"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NOTIFICATIONOPTIONS_DESCRIPTOR)
        field(PRINCIPALS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.notificationOptions?.let { field(NOTIFICATIONOPTIONS_DESCRIPTOR, it, ::serializeNotificationOptionsDocument) }
        if (input.principals != null) {
            listField(PRINCIPALS_DESCRIPTOR) {
                for (el0 in input.principals) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSharePrincipalDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
