// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.AbortDocumentVersionUploadRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AbortDocumentVersionUploadOperationSerializer: HttpSerializer.NonStreaming<AbortDocumentVersionUploadRequest> {
    override fun serialize(context: ExecutionContext, input: AbortDocumentVersionUploadRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.DELETE

        builder.url {
            requireNotNull(input.documentId) { "documentId is bound to the URI and must not be null" }
            requireNotNull(input.versionId) { "versionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("api"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("documents"))
                add(PercentEncoding.SmithyLabel.encode(input.documentId))
                add(PercentEncoding.Path.encode("versions"))
                add(PercentEncoding.SmithyLabel.encode(input.versionId))
            }
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        return builder
    }
}
