// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.workdocs.auth.DefaultWorkDocsAuthSchemeProvider
import aws.sdk.kotlin.services.workdocs.auth.WorkDocsAuthSchemeProvider
import aws.sdk.kotlin.services.workdocs.endpoints.DefaultWorkDocsEndpointProvider
import aws.sdk.kotlin.services.workdocs.endpoints.WorkDocsEndpointParameters
import aws.sdk.kotlin.services.workdocs.endpoints.WorkDocsEndpointProvider
import aws.sdk.kotlin.services.workdocs.model.AbortDocumentVersionUploadRequest
import aws.sdk.kotlin.services.workdocs.model.AbortDocumentVersionUploadResponse
import aws.sdk.kotlin.services.workdocs.model.ActivateUserRequest
import aws.sdk.kotlin.services.workdocs.model.ActivateUserResponse
import aws.sdk.kotlin.services.workdocs.model.AddResourcePermissionsRequest
import aws.sdk.kotlin.services.workdocs.model.AddResourcePermissionsResponse
import aws.sdk.kotlin.services.workdocs.model.CreateCommentRequest
import aws.sdk.kotlin.services.workdocs.model.CreateCommentResponse
import aws.sdk.kotlin.services.workdocs.model.CreateCustomMetadataRequest
import aws.sdk.kotlin.services.workdocs.model.CreateCustomMetadataResponse
import aws.sdk.kotlin.services.workdocs.model.CreateFolderRequest
import aws.sdk.kotlin.services.workdocs.model.CreateFolderResponse
import aws.sdk.kotlin.services.workdocs.model.CreateLabelsRequest
import aws.sdk.kotlin.services.workdocs.model.CreateLabelsResponse
import aws.sdk.kotlin.services.workdocs.model.CreateNotificationSubscriptionRequest
import aws.sdk.kotlin.services.workdocs.model.CreateNotificationSubscriptionResponse
import aws.sdk.kotlin.services.workdocs.model.CreateUserRequest
import aws.sdk.kotlin.services.workdocs.model.CreateUserResponse
import aws.sdk.kotlin.services.workdocs.model.DeactivateUserRequest
import aws.sdk.kotlin.services.workdocs.model.DeactivateUserResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteCommentRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteCommentResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteCustomMetadataRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteCustomMetadataResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteDocumentRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteDocumentResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteDocumentVersionRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteDocumentVersionResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteFolderContentsRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteFolderContentsResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteFolderRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteFolderResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteLabelsRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteLabelsResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteNotificationSubscriptionRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteNotificationSubscriptionResponse
import aws.sdk.kotlin.services.workdocs.model.DeleteUserRequest
import aws.sdk.kotlin.services.workdocs.model.DeleteUserResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeActivitiesRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeActivitiesResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeCommentsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeDocumentVersionsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeDocumentVersionsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeFolderContentsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeFolderContentsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeGroupsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeNotificationSubscriptionsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeNotificationSubscriptionsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeResourcePermissionsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeResourcePermissionsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeRootFoldersRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeRootFoldersResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeUsersRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeUsersResponse
import aws.sdk.kotlin.services.workdocs.model.GetCurrentUserRequest
import aws.sdk.kotlin.services.workdocs.model.GetCurrentUserResponse
import aws.sdk.kotlin.services.workdocs.model.GetDocumentPathRequest
import aws.sdk.kotlin.services.workdocs.model.GetDocumentPathResponse
import aws.sdk.kotlin.services.workdocs.model.GetDocumentRequest
import aws.sdk.kotlin.services.workdocs.model.GetDocumentResponse
import aws.sdk.kotlin.services.workdocs.model.GetDocumentVersionRequest
import aws.sdk.kotlin.services.workdocs.model.GetDocumentVersionResponse
import aws.sdk.kotlin.services.workdocs.model.GetFolderPathRequest
import aws.sdk.kotlin.services.workdocs.model.GetFolderPathResponse
import aws.sdk.kotlin.services.workdocs.model.GetFolderRequest
import aws.sdk.kotlin.services.workdocs.model.GetFolderResponse
import aws.sdk.kotlin.services.workdocs.model.GetResourcesRequest
import aws.sdk.kotlin.services.workdocs.model.GetResourcesResponse
import aws.sdk.kotlin.services.workdocs.model.InitiateDocumentVersionUploadRequest
import aws.sdk.kotlin.services.workdocs.model.InitiateDocumentVersionUploadResponse
import aws.sdk.kotlin.services.workdocs.model.RemoveAllResourcePermissionsRequest
import aws.sdk.kotlin.services.workdocs.model.RemoveAllResourcePermissionsResponse
import aws.sdk.kotlin.services.workdocs.model.RemoveResourcePermissionRequest
import aws.sdk.kotlin.services.workdocs.model.RemoveResourcePermissionResponse
import aws.sdk.kotlin.services.workdocs.model.RestoreDocumentVersionsRequest
import aws.sdk.kotlin.services.workdocs.model.RestoreDocumentVersionsResponse
import aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest
import aws.sdk.kotlin.services.workdocs.model.SearchResourcesResponse
import aws.sdk.kotlin.services.workdocs.model.UpdateDocumentRequest
import aws.sdk.kotlin.services.workdocs.model.UpdateDocumentResponse
import aws.sdk.kotlin.services.workdocs.model.UpdateDocumentVersionRequest
import aws.sdk.kotlin.services.workdocs.model.UpdateDocumentVersionResponse
import aws.sdk.kotlin.services.workdocs.model.UpdateFolderRequest
import aws.sdk.kotlin.services.workdocs.model.UpdateFolderResponse
import aws.sdk.kotlin.services.workdocs.model.UpdateUserRequest
import aws.sdk.kotlin.services.workdocs.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "WorkDocs"
public const val SdkVersion: String = "1.3.15"
public const val ServiceApiVersion: String = "2016-05-01"

/**
 * The Amazon WorkDocs API is designed for the following use cases:
 * + File Migration: File migration applications are supported for users who want to migrate their files from an on-premises or off-premises file system or service. Users can insert files into a user directory structure, as well as allow for basic metadata changes, such as modifications to the permissions of files.
 * + Security: Support security applications are supported for users who have additional security needs, such as antivirus or data loss prevention. The API actions, along with CloudTrail, allow these applications to detect when changes occur in Amazon WorkDocs. Then, the application can take the necessary actions and replace the target file. If the target file violates the policy, the application can also choose to email the user.
 * + eDiscovery/Analytics: General administrative applications are supported, such as eDiscovery and analytics. These applications can choose to mimic or record the actions in an Amazon WorkDocs site, along with CloudTrail, to replicate data for eDiscovery, backup, or analytical applications.
 *
 * All Amazon WorkDocs API actions are Amazon authenticated and certificate-signed. They not only require the use of the Amazon Web Services SDK, but also allow for the exclusive use of IAM users and roles to help facilitate access, trust, and permission policies. By creating a role and allowing an IAM user to access the Amazon WorkDocs site, the IAM user gains full administrative visibility into the entire Amazon WorkDocs site (or as set in the IAM policy). This includes, but is not limited to, the ability to modify file permissions and upload any file to any user. This allows developers to perform the three use cases above, as well as give users the ability to grant access on a selective basis using the IAM model.
 *
 * The pricing for Amazon WorkDocs APIs varies depending on the API call type for these actions:
 * + `READ (Get*)`
 * + `WRITE (Activate*, Add*, Create*, Deactivate*, Initiate*, Update*)`
 * + `LIST (Describe*)`
 * + `DELETE*, CANCEL`
 * For information about Amazon WorkDocs API pricing, see [Amazon WorkDocs Pricing](https://aws.amazon.com/workdocs/pricing/).
 */
public interface WorkDocsClient : SdkClient {
    /**
     * WorkDocsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WorkDocsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "WorkDocs",
                "WORKDOCS",
                "workdocs",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WorkDocsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WorkDocsClient = DefaultWorkDocsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: WorkDocsEndpointProvider = builder.endpointProvider ?: DefaultWorkDocsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: WorkDocsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultWorkDocsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WorkDocs"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: WorkDocsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: WorkDocsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Aborts the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload. The client should make this call only when it no longer intends to upload the document version, or fails to do so.
     */
    public suspend fun abortDocumentVersionUpload(input: AbortDocumentVersionUploadRequest): AbortDocumentVersionUploadResponse

    /**
     * Activates the specified user. Only active users can access Amazon WorkDocs.
     */
    public suspend fun activateUser(input: ActivateUserRequest): ActivateUserResponse

    /**
     * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if the principals already have different permissions.
     */
    public suspend fun addResourcePermissions(input: AddResourcePermissionsRequest): AddResourcePermissionsResponse

    /**
     * Adds a new comment to the specified document version.
     */
    public suspend fun createComment(input: CreateCommentRequest): CreateCommentResponse

    /**
     * Adds one or more custom properties to the specified resource (a folder, document, or version).
     */
    public suspend fun createCustomMetadata(input: CreateCustomMetadataRequest): CreateCustomMetadataResponse

    /**
     * Creates a folder with the specified name and parent folder.
     */
    public suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse

    /**
     * Adds the specified list of labels to the given resource (a document or folder)
     */
    public suspend fun createLabels(input: CreateLabelsRequest): CreateLabelsResponse

    /**
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must confirm the subscription.
     *
     * For more information, see [Setting up notifications for an IAM user or role](https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html) in the *Amazon WorkDocs Developer Guide*.
     */
    public suspend fun createNotificationSubscription(input: CreateNotificationSubscriptionRequest): CreateNotificationSubscriptionResponse

    /**
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
     */
    public suspend fun deactivateUser(input: DeactivateUserRequest): DeactivateUserResponse

    /**
     * Deletes the specified comment from the document version.
     */
    public suspend fun deleteComment(input: DeleteCommentRequest): DeleteCommentResponse

    /**
     * Deletes custom metadata from the specified resource.
     */
    public suspend fun deleteCustomMetadata(input: DeleteCustomMetadataRequest): DeleteCustomMetadataResponse

    /**
     * Permanently deletes the specified document and its associated metadata.
     */
    public suspend fun deleteDocument(input: DeleteDocumentRequest): DeleteDocumentResponse

    /**
     * Deletes a specific version of a document.
     */
    public suspend fun deleteDocumentVersion(input: DeleteDocumentVersionRequest): DeleteDocumentVersionResponse

    /**
     * Permanently deletes the specified folder and its contents.
     */
    public suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse

    /**
     * Deletes the contents of the specified folder.
     */
    public suspend fun deleteFolderContents(input: DeleteFolderContentsRequest): DeleteFolderContentsResponse

    /**
     * Deletes the specified list of labels from a resource.
     */
    public suspend fun deleteLabels(input: DeleteLabelsRequest): DeleteLabelsResponse

    /**
     * Deletes the specified subscription from the specified organization.
     */
    public suspend fun deleteNotificationSubscription(input: DeleteNotificationSubscriptionRequest): DeleteNotificationSubscriptionResponse

    /**
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     *
     * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention policies do NOT apply to this type of deletion.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Describes the user activities in a specified time period.
     */
    public suspend fun describeActivities(input: DescribeActivitiesRequest = DescribeActivitiesRequest { }): DescribeActivitiesResponse

    /**
     * List all the comments for the specified document version.
     */
    public suspend fun describeComments(input: DescribeCommentsRequest): DescribeCommentsResponse

    /**
     * Retrieves the document versions for the specified document.
     *
     * By default, only active versions are returned.
     */
    public suspend fun describeDocumentVersions(input: DescribeDocumentVersionsRequest): DescribeDocumentVersionsResponse

    /**
     * Describes the contents of the specified folder, including its documents and subfolders.
     *
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more results, the response includes a marker that you can use to request the next set of results. You can also request initialized documents.
     */
    public suspend fun describeFolderContents(input: DescribeFolderContentsRequest): DescribeFolderContentsResponse

    /**
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     */
    public suspend fun describeGroups(input: DescribeGroupsRequest): DescribeGroupsResponse

    /**
     * Lists the specified notification subscriptions.
     */
    public suspend fun describeNotificationSubscriptions(input: DescribeNotificationSubscriptionsRequest): DescribeNotificationSubscriptionsResponse

    /**
     * Describes the permissions of a specified resource.
     */
    public suspend fun describeResourcePermissions(input: DescribeResourcePermissionsRequest): DescribeResourcePermissionsResponse

    /**
     * Describes the current user's special folders; the `RootFolder` and the `RecycleBin`. `RootFolder` is the root of user's files and folders and `RecycleBin` is the root of recycled items. This is not a valid action for SigV4 (administrative API) clients.
     *
     * This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see [Authentication and Access Control for User Applications](https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html) in the *Amazon WorkDocs Developer Guide*.
     */
    public suspend fun describeRootFolders(input: DescribeRootFoldersRequest): DescribeRootFoldersResponse

    /**
     * Describes the specified users. You can describe all users or filter the results (for example, by status or organization).
     *
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response includes a marker that you can use to request the next set of results.
     */
    public suspend fun describeUsers(input: DescribeUsersRequest = DescribeUsersRequest { }): DescribeUsersResponse

    /**
     * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action for SigV4 (administrative API) clients.
     *
     * This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see [Authentication and Access Control for User Applications](https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html) in the *Amazon WorkDocs Developer Guide*.
     */
    public suspend fun getCurrentUser(input: GetCurrentUserRequest): GetCurrentUserResponse

    /**
     * Retrieves details of a document.
     */
    public suspend fun getDocument(input: GetDocumentRequest): GetDocumentResponse

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the requested document.
     *
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the names of the parent folders.
     */
    public suspend fun getDocumentPath(input: GetDocumentPathRequest): GetDocumentPathResponse

    /**
     * Retrieves version metadata for the specified document.
     */
    public suspend fun getDocumentVersion(input: GetDocumentVersionRequest): GetDocumentVersionResponse

    /**
     * Retrieves the metadata of the specified folder.
     */
    public suspend fun getFolder(input: GetFolderRequest): GetFolderResponse

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
     *
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the parent folder names.
     */
    public suspend fun getFolderPath(input: GetFolderPathRequest): GetFolderPathResponse

    /**
     * Retrieves a collection of resources, including folders and documents. The only `CollectionType` supported is `SHARED_WITH_ME`.
     */
    public suspend fun getResources(input: GetResourcesRequest = GetResourcesRequest { }): GetResourcesResponse

    /**
     * Creates a new document object and version object.
     *
     * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when creating a new version of an existing document. This is the first step to upload a document. Next, upload the document to the URL returned from the call, and then call UpdateDocumentVersion.
     *
     * To cancel the document upload, call AbortDocumentVersionUpload.
     */
    public suspend fun initiateDocumentVersionUpload(input: InitiateDocumentVersionUploadRequest = InitiateDocumentVersionUploadRequest { }): InitiateDocumentVersionUploadResponse

    /**
     * Removes all the permissions from the specified resource.
     */
    public suspend fun removeAllResourcePermissions(input: RemoveAllResourcePermissionsRequest): RemoveAllResourcePermissionsResponse

    /**
     * Removes the permission for the specified principal from the specified resource.
     */
    public suspend fun removeResourcePermission(input: RemoveResourcePermissionRequest): RemoveResourcePermissionResponse

    /**
     * Recovers a deleted version of an Amazon WorkDocs document.
     */
    public suspend fun restoreDocumentVersions(input: RestoreDocumentVersionsRequest): RestoreDocumentVersionsResponse

    /**
     * Searches metadata and the content of folders, documents, document versions, and comments.
     */
    public suspend fun searchResources(input: SearchResourcesRequest = SearchResourcesRequest { }): SearchResourcesResponse

    /**
     * Updates the specified attributes of a document. The user must have access to both the document and its parent folder, if applicable.
     */
    public suspend fun updateDocument(input: UpdateDocumentRequest): UpdateDocumentResponse

    /**
     * Changes the status of the document version to ACTIVE.
     *
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the client uploads the document to an S3-presigned URL returned by InitiateDocumentVersionUpload.
     */
    public suspend fun updateDocumentVersion(input: UpdateDocumentVersionRequest): UpdateDocumentVersionResponse

    /**
     * Updates the specified attributes of the specified folder. The user must have access to both the folder and its parent folder, if applicable.
     */
    public suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse

    /**
     * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WorkDocsClient.withConfig(block: WorkDocsClient.Config.Builder.() -> Unit): WorkDocsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWorkDocsClient(newConfig)
}

/**
 * Aborts the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload. The client should make this call only when it no longer intends to upload the document version, or fails to do so.
 */
public suspend inline fun WorkDocsClient.abortDocumentVersionUpload(crossinline block: AbortDocumentVersionUploadRequest.Builder.() -> Unit): AbortDocumentVersionUploadResponse = abortDocumentVersionUpload(AbortDocumentVersionUploadRequest.Builder().apply(block).build())

/**
 * Activates the specified user. Only active users can access Amazon WorkDocs.
 */
public suspend inline fun WorkDocsClient.activateUser(crossinline block: ActivateUserRequest.Builder.() -> Unit): ActivateUserResponse = activateUser(ActivateUserRequest.Builder().apply(block).build())

/**
 * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if the principals already have different permissions.
 */
public suspend inline fun WorkDocsClient.addResourcePermissions(crossinline block: AddResourcePermissionsRequest.Builder.() -> Unit): AddResourcePermissionsResponse = addResourcePermissions(AddResourcePermissionsRequest.Builder().apply(block).build())

/**
 * Adds a new comment to the specified document version.
 */
public suspend inline fun WorkDocsClient.createComment(crossinline block: CreateCommentRequest.Builder.() -> Unit): CreateCommentResponse = createComment(CreateCommentRequest.Builder().apply(block).build())

/**
 * Adds one or more custom properties to the specified resource (a folder, document, or version).
 */
public suspend inline fun WorkDocsClient.createCustomMetadata(crossinline block: CreateCustomMetadataRequest.Builder.() -> Unit): CreateCustomMetadataResponse = createCustomMetadata(CreateCustomMetadataRequest.Builder().apply(block).build())

/**
 * Creates a folder with the specified name and parent folder.
 */
public suspend inline fun WorkDocsClient.createFolder(crossinline block: CreateFolderRequest.Builder.() -> Unit): CreateFolderResponse = createFolder(CreateFolderRequest.Builder().apply(block).build())

/**
 * Adds the specified list of labels to the given resource (a document or folder)
 */
public suspend inline fun WorkDocsClient.createLabels(crossinline block: CreateLabelsRequest.Builder.() -> Unit): CreateLabelsResponse = createLabels(CreateLabelsRequest.Builder().apply(block).build())

/**
 * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must confirm the subscription.
 *
 * For more information, see [Setting up notifications for an IAM user or role](https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html) in the *Amazon WorkDocs Developer Guide*.
 */
public suspend inline fun WorkDocsClient.createNotificationSubscription(crossinline block: CreateNotificationSubscriptionRequest.Builder.() -> Unit): CreateNotificationSubscriptionResponse = createNotificationSubscription(CreateNotificationSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.
 */
public suspend inline fun WorkDocsClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
 */
public suspend inline fun WorkDocsClient.deactivateUser(crossinline block: DeactivateUserRequest.Builder.() -> Unit): DeactivateUserResponse = deactivateUser(DeactivateUserRequest.Builder().apply(block).build())

/**
 * Deletes the specified comment from the document version.
 */
public suspend inline fun WorkDocsClient.deleteComment(crossinline block: DeleteCommentRequest.Builder.() -> Unit): DeleteCommentResponse = deleteComment(DeleteCommentRequest.Builder().apply(block).build())

/**
 * Deletes custom metadata from the specified resource.
 */
public suspend inline fun WorkDocsClient.deleteCustomMetadata(crossinline block: DeleteCustomMetadataRequest.Builder.() -> Unit): DeleteCustomMetadataResponse = deleteCustomMetadata(DeleteCustomMetadataRequest.Builder().apply(block).build())

/**
 * Permanently deletes the specified document and its associated metadata.
 */
public suspend inline fun WorkDocsClient.deleteDocument(crossinline block: DeleteDocumentRequest.Builder.() -> Unit): DeleteDocumentResponse = deleteDocument(DeleteDocumentRequest.Builder().apply(block).build())

/**
 * Deletes a specific version of a document.
 */
public suspend inline fun WorkDocsClient.deleteDocumentVersion(crossinline block: DeleteDocumentVersionRequest.Builder.() -> Unit): DeleteDocumentVersionResponse = deleteDocumentVersion(DeleteDocumentVersionRequest.Builder().apply(block).build())

/**
 * Permanently deletes the specified folder and its contents.
 */
public suspend inline fun WorkDocsClient.deleteFolder(crossinline block: DeleteFolderRequest.Builder.() -> Unit): DeleteFolderResponse = deleteFolder(DeleteFolderRequest.Builder().apply(block).build())

/**
 * Deletes the contents of the specified folder.
 */
public suspend inline fun WorkDocsClient.deleteFolderContents(crossinline block: DeleteFolderContentsRequest.Builder.() -> Unit): DeleteFolderContentsResponse = deleteFolderContents(DeleteFolderContentsRequest.Builder().apply(block).build())

/**
 * Deletes the specified list of labels from a resource.
 */
public suspend inline fun WorkDocsClient.deleteLabels(crossinline block: DeleteLabelsRequest.Builder.() -> Unit): DeleteLabelsResponse = deleteLabels(DeleteLabelsRequest.Builder().apply(block).build())

/**
 * Deletes the specified subscription from the specified organization.
 */
public suspend inline fun WorkDocsClient.deleteNotificationSubscription(crossinline block: DeleteNotificationSubscriptionRequest.Builder.() -> Unit): DeleteNotificationSubscriptionResponse = deleteNotificationSubscription(DeleteNotificationSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes the specified user from a Simple AD or Microsoft AD directory.
 *
 * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention policies do NOT apply to this type of deletion.
 */
public suspend inline fun WorkDocsClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Describes the user activities in a specified time period.
 */
public suspend inline fun WorkDocsClient.describeActivities(crossinline block: DescribeActivitiesRequest.Builder.() -> Unit): DescribeActivitiesResponse = describeActivities(DescribeActivitiesRequest.Builder().apply(block).build())

/**
 * List all the comments for the specified document version.
 */
public suspend inline fun WorkDocsClient.describeComments(crossinline block: DescribeCommentsRequest.Builder.() -> Unit): DescribeCommentsResponse = describeComments(DescribeCommentsRequest.Builder().apply(block).build())

/**
 * Retrieves the document versions for the specified document.
 *
 * By default, only active versions are returned.
 */
public suspend inline fun WorkDocsClient.describeDocumentVersions(crossinline block: DescribeDocumentVersionsRequest.Builder.() -> Unit): DescribeDocumentVersionsResponse = describeDocumentVersions(DescribeDocumentVersionsRequest.Builder().apply(block).build())

/**
 * Describes the contents of the specified folder, including its documents and subfolders.
 *
 * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more results, the response includes a marker that you can use to request the next set of results. You can also request initialized documents.
 */
public suspend inline fun WorkDocsClient.describeFolderContents(crossinline block: DescribeFolderContentsRequest.Builder.() -> Unit): DescribeFolderContentsResponse = describeFolderContents(DescribeFolderContentsRequest.Builder().apply(block).build())

/**
 * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
 */
public suspend inline fun WorkDocsClient.describeGroups(crossinline block: DescribeGroupsRequest.Builder.() -> Unit): DescribeGroupsResponse = describeGroups(DescribeGroupsRequest.Builder().apply(block).build())

/**
 * Lists the specified notification subscriptions.
 */
public suspend inline fun WorkDocsClient.describeNotificationSubscriptions(crossinline block: DescribeNotificationSubscriptionsRequest.Builder.() -> Unit): DescribeNotificationSubscriptionsResponse = describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest.Builder().apply(block).build())

/**
 * Describes the permissions of a specified resource.
 */
public suspend inline fun WorkDocsClient.describeResourcePermissions(crossinline block: DescribeResourcePermissionsRequest.Builder.() -> Unit): DescribeResourcePermissionsResponse = describeResourcePermissions(DescribeResourcePermissionsRequest.Builder().apply(block).build())

/**
 * Describes the current user's special folders; the `RootFolder` and the `RecycleBin`. `RootFolder` is the root of user's files and folders and `RecycleBin` is the root of recycled items. This is not a valid action for SigV4 (administrative API) clients.
 *
 * This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see [Authentication and Access Control for User Applications](https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html) in the *Amazon WorkDocs Developer Guide*.
 */
public suspend inline fun WorkDocsClient.describeRootFolders(crossinline block: DescribeRootFoldersRequest.Builder.() -> Unit): DescribeRootFoldersResponse = describeRootFolders(DescribeRootFoldersRequest.Builder().apply(block).build())

/**
 * Describes the specified users. You can describe all users or filter the results (for example, by status or organization).
 *
 * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response includes a marker that you can use to request the next set of results.
 */
public suspend inline fun WorkDocsClient.describeUsers(crossinline block: DescribeUsersRequest.Builder.() -> Unit): DescribeUsersResponse = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

/**
 * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action for SigV4 (administrative API) clients.
 *
 * This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see [Authentication and Access Control for User Applications](https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html) in the *Amazon WorkDocs Developer Guide*.
 */
public suspend inline fun WorkDocsClient.getCurrentUser(crossinline block: GetCurrentUserRequest.Builder.() -> Unit): GetCurrentUserResponse = getCurrentUser(GetCurrentUserRequest.Builder().apply(block).build())

/**
 * Retrieves details of a document.
 */
public suspend inline fun WorkDocsClient.getDocument(crossinline block: GetDocumentRequest.Builder.() -> Unit): GetDocumentResponse = getDocument(GetDocumentRequest.Builder().apply(block).build())

/**
 * Retrieves the path information (the hierarchy from the root folder) for the requested document.
 *
 * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the names of the parent folders.
 */
public suspend inline fun WorkDocsClient.getDocumentPath(crossinline block: GetDocumentPathRequest.Builder.() -> Unit): GetDocumentPathResponse = getDocumentPath(GetDocumentPathRequest.Builder().apply(block).build())

/**
 * Retrieves version metadata for the specified document.
 */
public suspend inline fun WorkDocsClient.getDocumentVersion(crossinline block: GetDocumentVersionRequest.Builder.() -> Unit): GetDocumentVersionResponse = getDocumentVersion(GetDocumentVersionRequest.Builder().apply(block).build())

/**
 * Retrieves the metadata of the specified folder.
 */
public suspend inline fun WorkDocsClient.getFolder(crossinline block: GetFolderRequest.Builder.() -> Unit): GetFolderResponse = getFolder(GetFolderRequest.Builder().apply(block).build())

/**
 * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
 *
 * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the parent folder names.
 */
public suspend inline fun WorkDocsClient.getFolderPath(crossinline block: GetFolderPathRequest.Builder.() -> Unit): GetFolderPathResponse = getFolderPath(GetFolderPathRequest.Builder().apply(block).build())

/**
 * Retrieves a collection of resources, including folders and documents. The only `CollectionType` supported is `SHARED_WITH_ME`.
 */
public suspend inline fun WorkDocsClient.getResources(crossinline block: GetResourcesRequest.Builder.() -> Unit): GetResourcesResponse = getResources(GetResourcesRequest.Builder().apply(block).build())

/**
 * Creates a new document object and version object.
 *
 * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when creating a new version of an existing document. This is the first step to upload a document. Next, upload the document to the URL returned from the call, and then call UpdateDocumentVersion.
 *
 * To cancel the document upload, call AbortDocumentVersionUpload.
 */
public suspend inline fun WorkDocsClient.initiateDocumentVersionUpload(crossinline block: InitiateDocumentVersionUploadRequest.Builder.() -> Unit): InitiateDocumentVersionUploadResponse = initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest.Builder().apply(block).build())

/**
 * Removes all the permissions from the specified resource.
 */
public suspend inline fun WorkDocsClient.removeAllResourcePermissions(crossinline block: RemoveAllResourcePermissionsRequest.Builder.() -> Unit): RemoveAllResourcePermissionsResponse = removeAllResourcePermissions(RemoveAllResourcePermissionsRequest.Builder().apply(block).build())

/**
 * Removes the permission for the specified principal from the specified resource.
 */
public suspend inline fun WorkDocsClient.removeResourcePermission(crossinline block: RemoveResourcePermissionRequest.Builder.() -> Unit): RemoveResourcePermissionResponse = removeResourcePermission(RemoveResourcePermissionRequest.Builder().apply(block).build())

/**
 * Recovers a deleted version of an Amazon WorkDocs document.
 */
public suspend inline fun WorkDocsClient.restoreDocumentVersions(crossinline block: RestoreDocumentVersionsRequest.Builder.() -> Unit): RestoreDocumentVersionsResponse = restoreDocumentVersions(RestoreDocumentVersionsRequest.Builder().apply(block).build())

/**
 * Searches metadata and the content of folders, documents, document versions, and comments.
 */
public suspend inline fun WorkDocsClient.searchResources(crossinline block: SearchResourcesRequest.Builder.() -> Unit): SearchResourcesResponse = searchResources(SearchResourcesRequest.Builder().apply(block).build())

/**
 * Updates the specified attributes of a document. The user must have access to both the document and its parent folder, if applicable.
 */
public suspend inline fun WorkDocsClient.updateDocument(crossinline block: UpdateDocumentRequest.Builder.() -> Unit): UpdateDocumentResponse = updateDocument(UpdateDocumentRequest.Builder().apply(block).build())

/**
 * Changes the status of the document version to ACTIVE.
 *
 * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the client uploads the document to an S3-presigned URL returned by InitiateDocumentVersionUpload.
 */
public suspend inline fun WorkDocsClient.updateDocumentVersion(crossinline block: UpdateDocumentVersionRequest.Builder.() -> Unit): UpdateDocumentVersionResponse = updateDocumentVersion(UpdateDocumentVersionRequest.Builder().apply(block).build())

/**
 * Updates the specified attributes of the specified folder. The user must have access to both the folder and its parent folder, if applicable.
 */
public suspend inline fun WorkDocsClient.updateFolder(crossinline block: UpdateFolderRequest.Builder.() -> Unit): UpdateFolderResponse = updateFolder(UpdateFolderRequest.Builder().apply(block).build())

/**
 * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
 */
public suspend inline fun WorkDocsClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
