// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.CreateLabelsResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateLabelsOperationDeserializer: HttpDeserializer.NonStreaming<CreateLabelsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateLabelsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateLabelsError(context, call, payload)
        }
        val builder = CreateLabelsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateLabelsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyLabelsException" -> TooManyLabelsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkDocsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
