// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DescribeCommentsOperationSerializer: HttpSerialize<DescribeCommentsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DescribeCommentsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.documentId) { "documentId is bound to the URI and must not be null" }
            requireNotNull(input.versionId) { "versionId is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "api",
                "v1",
                "documents",
                "${input.documentId}".encodeLabel(),
                "versions",
                "${input.versionId}".encodeLabel(),
                "comments",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.limit != null) append("limit", "${input.limit}")
                if (input.marker != null) append("marker", input.marker)
            }
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        return builder
    }
}
