// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.DeleteDocumentVersionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteDocumentVersionOperationSerializer: HttpSerialize<DeleteDocumentVersionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DeleteDocumentVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.DELETE

        builder.url {
            requireNotNull(input.documentId) { "documentId is bound to the URI and must not be null" }
            requireNotNull(input.versionId) { "versionId is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "api",
                "v1",
                "documentVersions",
                "${input.documentId}".encodeLabel(),
                "versions",
                "${input.versionId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.deletePriorVersions != null) append("deletePriorVersions", "${input.deletePriorVersions}")
            }
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        return builder
    }
}
