// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.CommentVisibilityType
import aws.sdk.kotlin.services.workdocs.model.CreateCommentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCommentOperationSerializer: HttpSerialize<CreateCommentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateCommentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.documentId) { "documentId is bound to the URI and must not be null" }
            requireNotNull(input.versionId) { "versionId is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "api",
                "v1",
                "documents",
                "${input.documentId}".encodeLabel(),
                "versions",
                "${input.versionId}".encodeLabel(),
                "comment",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        val payload = serializeCreateCommentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateCommentOperationBody(context: ExecutionContext, input: CreateCommentRequest): ByteArray {
    val serializer = JsonSerializer()
    val NOTIFYCOLLABORATORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("NotifyCollaborators"))
    val PARENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ParentId"))
    val TEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Text"))
    val THREADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ThreadId"))
    val VISIBILITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Visibility"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NOTIFYCOLLABORATORS_DESCRIPTOR)
        field(PARENTID_DESCRIPTOR)
        field(TEXT_DESCRIPTOR)
        field(THREADID_DESCRIPTOR)
        field(VISIBILITY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.notifyCollaborators?.let { field(NOTIFYCOLLABORATORS_DESCRIPTOR, it) }
        input.parentId?.let { field(PARENTID_DESCRIPTOR, it) }
        input.text?.let { field(TEXT_DESCRIPTOR, it) }
        input.threadId?.let { field(THREADID_DESCRIPTOR, it) }
        input.visibility?.let { field(VISIBILITY_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
