// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.paginators

import aws.sdk.kotlin.services.workdocs.WorkDocsClient
import aws.sdk.kotlin.services.workdocs.model.Activity
import aws.sdk.kotlin.services.workdocs.model.Comment
import aws.sdk.kotlin.services.workdocs.model.DescribeActivitiesRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeActivitiesResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeCommentsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeDocumentVersionsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeDocumentVersionsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeFolderContentsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeFolderContentsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeGroupsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeNotificationSubscriptionsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeNotificationSubscriptionsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeResourcePermissionsRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeResourcePermissionsResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeRootFoldersRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeRootFoldersResponse
import aws.sdk.kotlin.services.workdocs.model.DescribeUsersRequest
import aws.sdk.kotlin.services.workdocs.model.DescribeUsersResponse
import aws.sdk.kotlin.services.workdocs.model.DocumentVersionMetadata
import aws.sdk.kotlin.services.workdocs.model.FolderMetadata
import aws.sdk.kotlin.services.workdocs.model.GroupMetadata
import aws.sdk.kotlin.services.workdocs.model.Principal
import aws.sdk.kotlin.services.workdocs.model.ResponseItem
import aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest
import aws.sdk.kotlin.services.workdocs.model.SearchResourcesResponse
import aws.sdk.kotlin.services.workdocs.model.Subscription
import aws.sdk.kotlin.services.workdocs.model.User
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeActivitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeActivitiesResponse]
 */
public fun WorkDocsClient.describeActivitiesPaginated(initialRequest: DescribeActivitiesRequest = DescribeActivitiesRequest { }): Flow<DescribeActivitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeActivitiesPaginated.describeActivities(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeActivitiesResponse]
 */
public fun WorkDocsClient.describeActivitiesPaginated(block: DescribeActivitiesRequest.Builder.() -> Unit): Flow<DescribeActivitiesResponse> =
    describeActivitiesPaginated(DescribeActivitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeActivitiesPaginated]
 * to access the nested member [Activity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Activity]
 */
@JvmName("describeActivitiesResponseActivity")
public fun Flow<DescribeActivitiesResponse>.userActivities(): Flow<Activity> =
    transform() { response ->
        response.userActivities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCommentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCommentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCommentsResponse]
 */
public fun WorkDocsClient.describeCommentsPaginated(initialRequest: DescribeCommentsRequest): Flow<DescribeCommentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCommentsPaginated.describeComments(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCommentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCommentsResponse]
 */
public fun WorkDocsClient.describeCommentsPaginated(block: DescribeCommentsRequest.Builder.() -> Unit): Flow<DescribeCommentsResponse> =
    describeCommentsPaginated(DescribeCommentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCommentsPaginated]
 * to access the nested member [Comment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Comment]
 */
@JvmName("describeCommentsResponseComment")
public fun Flow<DescribeCommentsResponse>.comments(): Flow<Comment> =
    transform() { response ->
        response.comments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDocumentVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDocumentVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDocumentVersionsResponse]
 */
public fun WorkDocsClient.describeDocumentVersionsPaginated(initialRequest: DescribeDocumentVersionsRequest): Flow<DescribeDocumentVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDocumentVersionsPaginated.describeDocumentVersions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDocumentVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDocumentVersionsResponse]
 */
public fun WorkDocsClient.describeDocumentVersionsPaginated(block: DescribeDocumentVersionsRequest.Builder.() -> Unit): Flow<DescribeDocumentVersionsResponse> =
    describeDocumentVersionsPaginated(DescribeDocumentVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDocumentVersionsPaginated]
 * to access the nested member [DocumentVersionMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DocumentVersionMetadata]
 */
@JvmName("describeDocumentVersionsResponseDocumentVersionMetadata")
public fun Flow<DescribeDocumentVersionsResponse>.documentVersions(): Flow<DocumentVersionMetadata> =
    transform() { response ->
        response.documentVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeFolderContentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFolderContentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFolderContentsResponse]
 */
public fun WorkDocsClient.describeFolderContentsPaginated(initialRequest: DescribeFolderContentsRequest): Flow<DescribeFolderContentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeFolderContentsPaginated.describeFolderContents(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFolderContentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFolderContentsResponse]
 */
public fun WorkDocsClient.describeFolderContentsPaginated(block: DescribeFolderContentsRequest.Builder.() -> Unit): Flow<DescribeFolderContentsResponse> =
    describeFolderContentsPaginated(DescribeFolderContentsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGroupsResponse]
 */
public fun WorkDocsClient.describeGroupsPaginated(initialRequest: DescribeGroupsRequest): Flow<DescribeGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeGroupsPaginated.describeGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGroupsResponse]
 */
public fun WorkDocsClient.describeGroupsPaginated(block: DescribeGroupsRequest.Builder.() -> Unit): Flow<DescribeGroupsResponse> =
    describeGroupsPaginated(DescribeGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGroupsPaginated]
 * to access the nested member [GroupMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupMetadata]
 */
@JvmName("describeGroupsResponseGroupMetadata")
public fun Flow<DescribeGroupsResponse>.groups(): Flow<GroupMetadata> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeNotificationSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeNotificationSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationSubscriptionsResponse]
 */
public fun WorkDocsClient.describeNotificationSubscriptionsPaginated(initialRequest: DescribeNotificationSubscriptionsRequest): Flow<DescribeNotificationSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeNotificationSubscriptionsPaginated.describeNotificationSubscriptions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeNotificationSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationSubscriptionsResponse]
 */
public fun WorkDocsClient.describeNotificationSubscriptionsPaginated(block: DescribeNotificationSubscriptionsRequest.Builder.() -> Unit): Flow<DescribeNotificationSubscriptionsResponse> =
    describeNotificationSubscriptionsPaginated(DescribeNotificationSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeNotificationSubscriptionsPaginated]
 * to access the nested member [Subscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Subscription]
 */
@JvmName("describeNotificationSubscriptionsResponseSubscription")
public fun Flow<DescribeNotificationSubscriptionsResponse>.subscriptions(): Flow<Subscription> =
    transform() { response ->
        response.subscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeResourcePermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeResourcePermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeResourcePermissionsResponse]
 */
public fun WorkDocsClient.describeResourcePermissionsPaginated(initialRequest: DescribeResourcePermissionsRequest): Flow<DescribeResourcePermissionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeResourcePermissionsPaginated.describeResourcePermissions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeResourcePermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeResourcePermissionsResponse]
 */
public fun WorkDocsClient.describeResourcePermissionsPaginated(block: DescribeResourcePermissionsRequest.Builder.() -> Unit): Flow<DescribeResourcePermissionsResponse> =
    describeResourcePermissionsPaginated(DescribeResourcePermissionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeResourcePermissionsPaginated]
 * to access the nested member [Principal]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Principal]
 */
@JvmName("describeResourcePermissionsResponsePrincipal")
public fun Flow<DescribeResourcePermissionsResponse>.principals(): Flow<Principal> =
    transform() { response ->
        response.principals?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeRootFoldersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRootFoldersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRootFoldersResponse]
 */
public fun WorkDocsClient.describeRootFoldersPaginated(initialRequest: DescribeRootFoldersRequest): Flow<DescribeRootFoldersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeRootFoldersPaginated.describeRootFolders(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRootFoldersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRootFoldersResponse]
 */
public fun WorkDocsClient.describeRootFoldersPaginated(block: DescribeRootFoldersRequest.Builder.() -> Unit): Flow<DescribeRootFoldersResponse> =
    describeRootFoldersPaginated(DescribeRootFoldersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeRootFoldersPaginated]
 * to access the nested member [FolderMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FolderMetadata]
 */
@JvmName("describeRootFoldersResponseFolderMetadata")
public fun Flow<DescribeRootFoldersResponse>.folders(): Flow<FolderMetadata> =
    transform() { response ->
        response.folders?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsersResponse]
 */
public fun WorkDocsClient.describeUsersPaginated(initialRequest: DescribeUsersRequest = DescribeUsersRequest { }): Flow<DescribeUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeUsersPaginated.describeUsers(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsersResponse]
 */
public fun WorkDocsClient.describeUsersPaginated(block: DescribeUsersRequest.Builder.() -> Unit): Flow<DescribeUsersResponse> =
    describeUsersPaginated(DescribeUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeUsersPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("describeUsersResponseUser")
public fun Flow<DescribeUsersResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResourcesResponse]
 */
public fun WorkDocsClient.searchResourcesPaginated(initialRequest: SearchResourcesRequest = SearchResourcesRequest { }): Flow<SearchResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@searchResourcesPaginated.searchResources(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResourcesResponse]
 */
public fun WorkDocsClient.searchResourcesPaginated(block: SearchResourcesRequest.Builder.() -> Unit): Flow<SearchResourcesResponse> =
    searchResourcesPaginated(SearchResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchResourcesPaginated]
 * to access the nested member [ResponseItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResponseItem]
 */
@JvmName("searchResourcesResponseResponseItem")
public fun Flow<SearchResourcesResponse>.items(): Flow<ResponseItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
