// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model



public class DescribeUsersRequest private constructor(builder: Builder) {
    /**
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
     */
    public val authenticationToken: kotlin.String? = builder.authenticationToken
    /**
     * A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.
     */
    public val fields: kotlin.String? = builder.fields
    /**
     * The state of the users. Specify "ALL" to include inactive users.
     */
    public val include: aws.sdk.kotlin.services.workdocs.model.UserFilterType? = builder.include
    /**
     * The maximum number of items to return.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The marker for the next set of results. (You received this marker from a previous call.)
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The order for the results.
     */
    public val order: aws.sdk.kotlin.services.workdocs.model.OrderType? = builder.order
    /**
     * The ID of the organization.
     */
    public val organizationId: kotlin.String? = builder.organizationId
    /**
     * A query to filter users by user name. Remember the following about the `Userids` and `Query` parameters:
     * + If you don't use either parameter, the API returns a paginated list of all users on the site.
     * + If you use both parameters, the API ignores the `Query` parameter.
     * + The `Userid` parameter only returns user names that match a corresponding user ID.
     * + The `Query` parameter runs a "prefix" search for users by the `GivenName`, `SurName`, or `UserName` fields included in a [CreateUser](https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html) API call. For example, querying on `Ma` returns Márcia Oliveira, María García, and Mateo Jackson. If you use multiple characters, the API only returns data that matches all characters. For example, querying on `Ma J` only returns Mateo Jackson.
     */
    public val query: kotlin.String? = builder.query
    /**
     * The sorting criteria.
     */
    public val sort: aws.sdk.kotlin.services.workdocs.model.UserSortType? = builder.sort
    /**
     * The IDs of the users.
     */
    public val userIds: kotlin.String? = builder.userIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.DescribeUsersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeUsersRequest(")
        append("authenticationToken=*** Sensitive Data Redacted ***,")
        append("fields=$fields,")
        append("include=$include,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("order=$order,")
        append("organizationId=$organizationId,")
        append("query=*** Sensitive Data Redacted ***,")
        append("sort=$sort,")
        append("userIds=$userIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationToken?.hashCode() ?: 0
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (include?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (order?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (query?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeUsersRequest

        if (authenticationToken != other.authenticationToken) return false
        if (fields != other.fields) return false
        if (include != other.include) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (order != other.order) return false
        if (organizationId != other.organizationId) return false
        if (query != other.query) return false
        if (sort != other.sort) return false
        if (userIds != other.userIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.DescribeUsersRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
         */
        public var authenticationToken: kotlin.String? = null
        /**
         * A comma-separated list of values. Specify "STORAGE_METADATA" to include the user storage quota and utilization information.
         */
        public var fields: kotlin.String? = null
        /**
         * The state of the users. Specify "ALL" to include inactive users.
         */
        public var include: aws.sdk.kotlin.services.workdocs.model.UserFilterType? = null
        /**
         * The maximum number of items to return.
         */
        public var limit: kotlin.Int? = null
        /**
         * The marker for the next set of results. (You received this marker from a previous call.)
         */
        public var marker: kotlin.String? = null
        /**
         * The order for the results.
         */
        public var order: aws.sdk.kotlin.services.workdocs.model.OrderType? = null
        /**
         * The ID of the organization.
         */
        public var organizationId: kotlin.String? = null
        /**
         * A query to filter users by user name. Remember the following about the `Userids` and `Query` parameters:
         * + If you don't use either parameter, the API returns a paginated list of all users on the site.
         * + If you use both parameters, the API ignores the `Query` parameter.
         * + The `Userid` parameter only returns user names that match a corresponding user ID.
         * + The `Query` parameter runs a "prefix" search for users by the `GivenName`, `SurName`, or `UserName` fields included in a [CreateUser](https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html) API call. For example, querying on `Ma` returns Márcia Oliveira, María García, and Mateo Jackson. If you use multiple characters, the API only returns data that matches all characters. For example, querying on `Ma J` only returns Mateo Jackson.
         */
        public var query: kotlin.String? = null
        /**
         * The sorting criteria.
         */
        public var sort: aws.sdk.kotlin.services.workdocs.model.UserSortType? = null
        /**
         * The IDs of the users.
         */
        public var userIds: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.DescribeUsersRequest) : this() {
            this.authenticationToken = x.authenticationToken
            this.fields = x.fields
            this.include = x.include
            this.limit = x.limit
            this.marker = x.marker
            this.order = x.order
            this.organizationId = x.organizationId
            this.query = x.query
            this.sort = x.sort
            this.userIds = x.userIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.DescribeUsersRequest = DescribeUsersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
