// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.serde

import aws.sdk.kotlin.services.workdocs.model.DeleteCommentResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteCommentOperationDeserializer: HttpDeserialize<DeleteCommentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteCommentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteCommentError(context, call)
        }
        val builder = DeleteCommentResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteCommentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DocumentLockedForCommentsException" -> DocumentLockedForCommentsExceptionDeserializer().deserialize(context, wrappedCall)
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer().deserialize(context, wrappedCall)
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkDocsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
