// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model



public class DescribeCommentsRequest private constructor(builder: Builder) {
    /**
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
     */
    public val authenticationToken: kotlin.String? = builder.authenticationToken
    /**
     * The ID of the document.
     */
    public val documentId: kotlin.String? = requireNotNull(builder.documentId) { "A non-null value must be provided for documentId" }
    /**
     * The maximum number of items to return.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The marker for the next set of results. This marker was received from a previous call.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The ID of the document version.
     */
    public val versionId: kotlin.String? = requireNotNull(builder.versionId) { "A non-null value must be provided for versionId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCommentsRequest(")
        append("authenticationToken=*** Sensitive Data Redacted ***,")
        append("documentId=$documentId,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationToken?.hashCode() ?: 0
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCommentsRequest

        if (authenticationToken != other.authenticationToken) return false
        if (documentId != other.documentId) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
         */
        public var authenticationToken: kotlin.String? = null
        /**
         * The ID of the document.
         */
        public var documentId: kotlin.String? = null
        /**
         * The maximum number of items to return.
         */
        public var limit: kotlin.Int? = null
        /**
         * The marker for the next set of results. This marker was received from a previous call.
         */
        public var marker: kotlin.String? = null
        /**
         * The ID of the document version.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest) : this() {
            this.authenticationToken = x.authenticationToken
            this.documentId = x.documentId
            this.limit = x.limit
            this.marker = x.marker
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.DescribeCommentsRequest = DescribeCommentsRequest(this)

        internal fun correctErrors(): Builder {
            if (documentId == null) documentId = ""
            if (versionId == null) versionId = ""
            return this
        }
    }
}
