// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a comment.
 */
public class Comment private constructor(builder: Builder) {
    /**
     * The ID of the comment.
     */
    public val commentId: kotlin.String? = builder.commentId
    /**
     * The details of the user who made the comment.
     */
    public val contributor: aws.sdk.kotlin.services.workdocs.model.User? = builder.contributor
    /**
     * The time that the comment was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The ID of the parent comment.
     */
    public val parentId: kotlin.String? = builder.parentId
    /**
     * If the comment is a reply to another user's comment, this field contains the user ID of the user being replied to.
     */
    public val recipientId: kotlin.String? = builder.recipientId
    /**
     * The status of the comment.
     */
    public val status: aws.sdk.kotlin.services.workdocs.model.CommentStatusType? = builder.status
    /**
     * The text of the comment.
     */
    public val text: kotlin.String? = builder.text
    /**
     * The ID of the root comment in the thread.
     */
    public val threadId: kotlin.String? = builder.threadId
    /**
     * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.
     */
    public val visibility: aws.sdk.kotlin.services.workdocs.model.CommentVisibilityType? = builder.visibility

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.Comment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Comment(")
        append("commentId=$commentId,")
        append("contributor=$contributor,")
        append("createdTimestamp=$createdTimestamp,")
        append("parentId=$parentId,")
        append("recipientId=$recipientId,")
        append("status=$status,")
        append("text=*** Sensitive Data Redacted ***,")
        append("threadId=$threadId,")
        append("visibility=$visibility")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commentId?.hashCode() ?: 0
        result = 31 * result + (contributor?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (parentId?.hashCode() ?: 0)
        result = 31 * result + (recipientId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (threadId?.hashCode() ?: 0)
        result = 31 * result + (visibility?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Comment

        if (commentId != other.commentId) return false
        if (contributor != other.contributor) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (parentId != other.parentId) return false
        if (recipientId != other.recipientId) return false
        if (status != other.status) return false
        if (text != other.text) return false
        if (threadId != other.threadId) return false
        if (visibility != other.visibility) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.Comment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the comment.
         */
        public var commentId: kotlin.String? = null
        /**
         * The details of the user who made the comment.
         */
        public var contributor: aws.sdk.kotlin.services.workdocs.model.User? = null
        /**
         * The time that the comment was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the parent comment.
         */
        public var parentId: kotlin.String? = null
        /**
         * If the comment is a reply to another user's comment, this field contains the user ID of the user being replied to.
         */
        public var recipientId: kotlin.String? = null
        /**
         * The status of the comment.
         */
        public var status: aws.sdk.kotlin.services.workdocs.model.CommentStatusType? = null
        /**
         * The text of the comment.
         */
        public var text: kotlin.String? = null
        /**
         * The ID of the root comment in the thread.
         */
        public var threadId: kotlin.String? = null
        /**
         * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners, and contributors.
         */
        public var visibility: aws.sdk.kotlin.services.workdocs.model.CommentVisibilityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.Comment) : this() {
            this.commentId = x.commentId
            this.contributor = x.contributor
            this.createdTimestamp = x.createdTimestamp
            this.parentId = x.parentId
            this.recipientId = x.recipientId
            this.status = x.status
            this.text = x.text
            this.threadId = x.threadId
            this.visibility = x.visibility
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.Comment = Comment(this)

        /**
         * construct an [aws.sdk.kotlin.services.workdocs.model.User] inside the given [block]
         */
        public fun contributor(block: aws.sdk.kotlin.services.workdocs.model.User.Builder.() -> kotlin.Unit) {
            this.contributor = aws.sdk.kotlin.services.workdocs.model.User.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (commentId == null) commentId = ""
            return this
        }
    }
}
