// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.services.workdocs.model.UpdateFolderResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateFolderOperationDeserializer: HttpDeserialize<UpdateFolderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateFolderResponse {
        if (!response.status.isSuccess()) {
            throwUpdateFolderError(context, response)
        }
        val builder = UpdateFolderResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateFolderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityAlreadyExistsException" -> EntityAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkDocsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
