// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.services.workdocs.model.AdditionalResponseFieldType
import aws.sdk.kotlin.services.workdocs.model.Filters
import aws.sdk.kotlin.services.workdocs.model.SearchQueryScopeType
import aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest
import aws.sdk.kotlin.services.workdocs.model.SearchSortResult
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchResourcesOperationSerializer: HttpSerialize<SearchResourcesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchResourcesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/api/v1/search"
        }

        builder.headers {
            if (input.authenticationToken?.isNotEmpty() == true) append("Authentication", input.authenticationToken)
        }

        val payload = serializeSearchResourcesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchResourcesOperationBody(context: ExecutionContext, input: SearchResourcesRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALRESPONSEFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdditionalResponseFields"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val LIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Limit"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val ORDERBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OrderBy"))
    val ORGANIZATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrganizationId"))
    val QUERYSCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryScopes"))
    val QUERYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryText"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALRESPONSEFIELDS_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(LIMIT_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(ORDERBY_DESCRIPTOR)
        field(ORGANIZATIONID_DESCRIPTOR)
        field(QUERYSCOPES_DESCRIPTOR)
        field(QUERYTEXT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalResponseFields != null) {
            listField(ADDITIONALRESPONSEFIELDS_DESCRIPTOR) {
                for (el0 in input.additionalResponseFields) {
                    serializeString(el0.value)
                }
            }
        }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeFiltersDocument) }
        input.limit?.let { field(LIMIT_DESCRIPTOR, it) }
        input.marker?.let { field(MARKER_DESCRIPTOR, it) }
        if (input.orderBy != null) {
            listField(ORDERBY_DESCRIPTOR) {
                for (el0 in input.orderBy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSearchSortResultDocument))
                }
            }
        }
        input.organizationId?.let { field(ORGANIZATIONID_DESCRIPTOR, it) }
        if (input.queryScopes != null) {
            listField(QUERYSCOPES_DESCRIPTOR) {
                for (el0 in input.queryScopes) {
                    serializeString(el0.value)
                }
            }
        }
        input.queryText?.let { field(QUERYTEXT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
