// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.transform

import aws.sdk.kotlin.services.workdocs.model.DocumentVersionMetadata
import aws.sdk.kotlin.services.workdocs.model.GetDocumentVersionResponse
import aws.sdk.kotlin.services.workdocs.model.WorkDocsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetDocumentVersionOperationDeserializer: HttpDeserialize<GetDocumentVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDocumentVersionResponse {
        if (!response.status.isSuccess()) {
            throwGetDocumentVersionError(context, response)
        }
        val builder = GetDocumentVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDocumentVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDocumentVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkDocsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EntityNotExistsException" -> EntityNotExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "FailedDependencyException" -> FailedDependencyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPasswordException" -> InvalidPasswordExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProhibitedStateException" -> ProhibitedStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedResourceAccessException" -> UnauthorizedResourceAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkDocsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDocumentVersionOperationBody(builder: GetDocumentVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("CustomMetadata"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Metadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMMETADATA_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMMETADATA_DESCRIPTOR.index -> builder.customMetadata =
                    deserializer.deserializeMap(CUSTOMMETADATA_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeDocumentVersionMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
