// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model



public class SearchResourcesRequest private constructor(builder: Builder) {
    /**
     * A list of attributes to include in the response. Used to request fields that are not normally returned in a standard response.
     */
    public val additionalResponseFields: List<AdditionalResponseFieldType>? = builder.additionalResponseFields
    /**
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
     */
    public val authenticationToken: kotlin.String? = builder.authenticationToken
    /**
     * Filters results based on entity metadata.
     */
    public val filters: aws.sdk.kotlin.services.workdocs.model.Filters? = builder.filters
    /**
     * Max results count per page.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The marker for the next set of results.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * Order by results in one or more categories.
     */
    public val orderBy: List<SearchSortResult>? = builder.orderBy
    /**
     * Filters based on the resource owner OrgId. This is a mandatory parameter when using Admin SigV4 credentials.
     */
    public val organizationId: kotlin.String? = builder.organizationId
    /**
     * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and no name. A Document or Document Version has a name and content
     */
    public val queryScopes: List<SearchQueryScopeType>? = builder.queryScopes
    /**
     * The String to search for. Searches across different text fields based on request parameters. Use double quotes around the query string for exact phrase matches.
     */
    public val queryText: kotlin.String? = builder.queryText

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchResourcesRequest(")
        append("additionalResponseFields=$additionalResponseFields,")
        append("authenticationToken=*** Sensitive Data Redacted ***,")
        append("filters=$filters,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("orderBy=$orderBy,")
        append("organizationId=$organizationId,")
        append("queryScopes=$queryScopes,")
        append("queryText=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalResponseFields?.hashCode() ?: 0
        result = 31 * result + (authenticationToken?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (queryScopes?.hashCode() ?: 0)
        result = 31 * result + (queryText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchResourcesRequest

        if (additionalResponseFields != other.additionalResponseFields) return false
        if (authenticationToken != other.authenticationToken) return false
        if (filters != other.filters) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (orderBy != other.orderBy) return false
        if (organizationId != other.organizationId) return false
        if (queryScopes != other.queryScopes) return false
        if (queryText != other.queryText) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of attributes to include in the response. Used to request fields that are not normally returned in a standard response.
         */
        public var additionalResponseFields: List<AdditionalResponseFieldType>? = null
        /**
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
         */
        public var authenticationToken: kotlin.String? = null
        /**
         * Filters results based on entity metadata.
         */
        public var filters: aws.sdk.kotlin.services.workdocs.model.Filters? = null
        /**
         * Max results count per page.
         */
        public var limit: kotlin.Int? = null
        /**
         * The marker for the next set of results.
         */
        public var marker: kotlin.String? = null
        /**
         * Order by results in one or more categories.
         */
        public var orderBy: List<SearchSortResult>? = null
        /**
         * Filters based on the resource owner OrgId. This is a mandatory parameter when using Admin SigV4 credentials.
         */
        public var organizationId: kotlin.String? = null
        /**
         * Filter based on the text field type. A Folder has only a name and no content. A Comment has only content and no name. A Document or Document Version has a name and content
         */
        public var queryScopes: List<SearchQueryScopeType>? = null
        /**
         * The String to search for. Searches across different text fields based on request parameters. Use double quotes around the query string for exact phrase matches.
         */
        public var queryText: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest) : this() {
            this.additionalResponseFields = x.additionalResponseFields
            this.authenticationToken = x.authenticationToken
            this.filters = x.filters
            this.limit = x.limit
            this.marker = x.marker
            this.orderBy = x.orderBy
            this.organizationId = x.organizationId
            this.queryScopes = x.queryScopes
            this.queryText = x.queryText
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.SearchResourcesRequest = SearchResourcesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.workdocs.model.Filters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.workdocs.model.Filters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.workdocs.model.Filters.invoke(block)
        }
    }
}
