// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs.model



public class DescribeGroupsRequest private constructor(builder: Builder) {
    /**
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
     */
    public val authenticationToken: kotlin.String? = builder.authenticationToken
    /**
     * The maximum number of items to return with this call.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The marker for the next set of results. (You received this marker from a previous call.)
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The ID of the organization.
     */
    public val organizationId: kotlin.String? = builder.organizationId
    /**
     * A query to describe groups by group name.
     */
    public val searchQuery: kotlin.String? = requireNotNull(builder.searchQuery) { "A non-null value must be provided for searchQuery" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGroupsRequest(")
        append("authenticationToken=*** Sensitive Data Redacted ***,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("organizationId=$organizationId,")
        append("searchQuery=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationToken?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (searchQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGroupsRequest

        if (authenticationToken != other.authenticationToken) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (organizationId != other.organizationId) return false
        if (searchQuery != other.searchQuery) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to access the API.
         */
        public var authenticationToken: kotlin.String? = null
        /**
         * The maximum number of items to return with this call.
         */
        public var limit: kotlin.Int? = null
        /**
         * The marker for the next set of results. (You received this marker from a previous call.)
         */
        public var marker: kotlin.String? = null
        /**
         * The ID of the organization.
         */
        public var organizationId: kotlin.String? = null
        /**
         * A query to describe groups by group name.
         */
        public var searchQuery: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest) : this() {
            this.authenticationToken = x.authenticationToken
            this.limit = x.limit
            this.marker = x.marker
            this.organizationId = x.organizationId
            this.searchQuery = x.searchQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workdocs.model.DescribeGroupsRequest = DescribeGroupsRequest(this)
    }
}
