// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workdocs

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.workdocs.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.workdocs.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.workdocs.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.workdocs.model.*
import aws.sdk.kotlin.services.workdocs.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "WorkDocs"
public const val ServiceApiVersion: String = "2016-05-01"
public const val SdkVersion: String = "0.26.0-beta"

internal class DefaultWorkDocsClient(override val config: WorkDocsClient.Config) : WorkDocsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "workdocs")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Aborts the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload. The client should make this call only when it no longer intends to upload the document version, or fails to do so.
     */
    override suspend fun abortDocumentVersionUpload(input: AbortDocumentVersionUploadRequest): AbortDocumentVersionUploadResponse {
        val op = SdkHttpOperation.build<AbortDocumentVersionUploadRequest, AbortDocumentVersionUploadResponse> {
            serializer = AbortDocumentVersionUploadOperationSerializer()
            deserializer = AbortDocumentVersionUploadOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "AbortDocumentVersionUpload"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AbortDocumentVersionUpload-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Activates the specified user. Only active users can access Amazon WorkDocs.
     */
    override suspend fun activateUser(input: ActivateUserRequest): ActivateUserResponse {
        val op = SdkHttpOperation.build<ActivateUserRequest, ActivateUserResponse> {
            serializer = ActivateUserOperationSerializer()
            deserializer = ActivateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ActivateUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ActivateUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if the principals already have different permissions.
     */
    override suspend fun addResourcePermissions(input: AddResourcePermissionsRequest): AddResourcePermissionsResponse {
        val op = SdkHttpOperation.build<AddResourcePermissionsRequest, AddResourcePermissionsResponse> {
            serializer = AddResourcePermissionsOperationSerializer()
            deserializer = AddResourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "AddResourcePermissions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddResourcePermissions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds a new comment to the specified document version.
     */
    override suspend fun createComment(input: CreateCommentRequest): CreateCommentResponse {
        val op = SdkHttpOperation.build<CreateCommentRequest, CreateCommentResponse> {
            serializer = CreateCommentOperationSerializer()
            deserializer = CreateCommentOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateComment"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateComment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds one or more custom properties to the specified resource (a folder, document, or version).
     */
    override suspend fun createCustomMetadata(input: CreateCustomMetadataRequest): CreateCustomMetadataResponse {
        val op = SdkHttpOperation.build<CreateCustomMetadataRequest, CreateCustomMetadataResponse> {
            serializer = CreateCustomMetadataOperationSerializer()
            deserializer = CreateCustomMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateCustomMetadata"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCustomMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a folder with the specified name and parent folder.
     */
    override suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse {
        val op = SdkHttpOperation.build<CreateFolderRequest, CreateFolderResponse> {
            serializer = CreateFolderOperationSerializer()
            deserializer = CreateFolderOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateFolder"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFolder-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds the specified list of labels to the given resource (a document or folder)
     */
    override suspend fun createLabels(input: CreateLabelsRequest): CreateLabelsResponse {
        val op = SdkHttpOperation.build<CreateLabelsRequest, CreateLabelsResponse> {
            serializer = CreateLabelsOperationSerializer()
            deserializer = CreateLabelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateLabels"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateLabels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must confirm the subscription.
     *
     * For more information, see [Setting up notifications for an IAM user or role](https://docs.aws.amazon.com/workdocs/latest/developerguide/manage-notifications.html) in the *Amazon WorkDocs Developer Guide*.
     */
    override suspend fun createNotificationSubscription(input: CreateNotificationSubscriptionRequest): CreateNotificationSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateNotificationSubscriptionRequest, CreateNotificationSubscriptionResponse> {
            serializer = CreateNotificationSubscriptionOperationSerializer()
            deserializer = CreateNotificationSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateNotificationSubscription"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateNotificationSubscription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
     */
    override suspend fun deactivateUser(input: DeactivateUserRequest): DeactivateUserResponse {
        val op = SdkHttpOperation.build<DeactivateUserRequest, DeactivateUserResponse> {
            serializer = DeactivateUserOperationSerializer()
            deserializer = DeactivateUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeactivateUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeactivateUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified comment from the document version.
     */
    override suspend fun deleteComment(input: DeleteCommentRequest): DeleteCommentResponse {
        val op = SdkHttpOperation.build<DeleteCommentRequest, DeleteCommentResponse> {
            serializer = DeleteCommentOperationSerializer()
            deserializer = DeleteCommentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteComment"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteComment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes custom metadata from the specified resource.
     */
    override suspend fun deleteCustomMetadata(input: DeleteCustomMetadataRequest): DeleteCustomMetadataResponse {
        val op = SdkHttpOperation.build<DeleteCustomMetadataRequest, DeleteCustomMetadataResponse> {
            serializer = DeleteCustomMetadataOperationSerializer()
            deserializer = DeleteCustomMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteCustomMetadata"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCustomMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Permanently deletes the specified document and its associated metadata.
     */
    override suspend fun deleteDocument(input: DeleteDocumentRequest): DeleteDocumentResponse {
        val op = SdkHttpOperation.build<DeleteDocumentRequest, DeleteDocumentResponse> {
            serializer = DeleteDocumentOperationSerializer()
            deserializer = DeleteDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteDocument"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDocument-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specific version of a document.
     */
    override suspend fun deleteDocumentVersion(input: DeleteDocumentVersionRequest): DeleteDocumentVersionResponse {
        val op = SdkHttpOperation.build<DeleteDocumentVersionRequest, DeleteDocumentVersionResponse> {
            serializer = DeleteDocumentVersionOperationSerializer()
            deserializer = DeleteDocumentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteDocumentVersion"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDocumentVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Permanently deletes the specified folder and its contents.
     */
    override suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse {
        val op = SdkHttpOperation.build<DeleteFolderRequest, DeleteFolderResponse> {
            serializer = DeleteFolderOperationSerializer()
            deserializer = DeleteFolderOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFolder"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFolder-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the contents of the specified folder.
     */
    override suspend fun deleteFolderContents(input: DeleteFolderContentsRequest): DeleteFolderContentsResponse {
        val op = SdkHttpOperation.build<DeleteFolderContentsRequest, DeleteFolderContentsResponse> {
            serializer = DeleteFolderContentsOperationSerializer()
            deserializer = DeleteFolderContentsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFolderContents"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFolderContents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified list of labels from a resource.
     */
    override suspend fun deleteLabels(input: DeleteLabelsRequest): DeleteLabelsResponse {
        val op = SdkHttpOperation.build<DeleteLabelsRequest, DeleteLabelsResponse> {
            serializer = DeleteLabelsOperationSerializer()
            deserializer = DeleteLabelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteLabels"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteLabels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified subscription from the specified organization.
     */
    override suspend fun deleteNotificationSubscription(input: DeleteNotificationSubscriptionRequest): DeleteNotificationSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteNotificationSubscriptionRequest, DeleteNotificationSubscriptionResponse> {
            serializer = DeleteNotificationSubscriptionOperationSerializer()
            deserializer = DeleteNotificationSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteNotificationSubscription"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteNotificationSubscription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified user from a Simple AD or Microsoft AD directory.
     *
     * Deleting a user immediately and permanently deletes all content in that user's folder structure. Site retention policies do NOT apply to this type of deletion.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the user activities in a specified time period.
     */
    override suspend fun describeActivities(input: DescribeActivitiesRequest): DescribeActivitiesResponse {
        val op = SdkHttpOperation.build<DescribeActivitiesRequest, DescribeActivitiesResponse> {
            serializer = DescribeActivitiesOperationSerializer()
            deserializer = DescribeActivitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeActivities"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeActivities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List all the comments for the specified document version.
     */
    override suspend fun describeComments(input: DescribeCommentsRequest): DescribeCommentsResponse {
        val op = SdkHttpOperation.build<DescribeCommentsRequest, DescribeCommentsResponse> {
            serializer = DescribeCommentsOperationSerializer()
            deserializer = DescribeCommentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeComments"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeComments-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the document versions for the specified document.
     *
     * By default, only active versions are returned.
     */
    override suspend fun describeDocumentVersions(input: DescribeDocumentVersionsRequest): DescribeDocumentVersionsResponse {
        val op = SdkHttpOperation.build<DescribeDocumentVersionsRequest, DescribeDocumentVersionsResponse> {
            serializer = DescribeDocumentVersionsOperationSerializer()
            deserializer = DescribeDocumentVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDocumentVersions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDocumentVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the contents of the specified folder, including its documents and subfolders.
     *
     * By default, Amazon WorkDocs returns the first 100 active document and folder metadata items. If there are more results, the response includes a marker that you can use to request the next set of results. You can also request initialized documents.
     */
    override suspend fun describeFolderContents(input: DescribeFolderContentsRequest): DescribeFolderContentsResponse {
        val op = SdkHttpOperation.build<DescribeFolderContentsRequest, DescribeFolderContentsResponse> {
            serializer = DescribeFolderContentsOperationSerializer()
            deserializer = DescribeFolderContentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeFolderContents"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFolderContents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
     */
    override suspend fun describeGroups(input: DescribeGroupsRequest): DescribeGroupsResponse {
        val op = SdkHttpOperation.build<DescribeGroupsRequest, DescribeGroupsResponse> {
            serializer = DescribeGroupsOperationSerializer()
            deserializer = DescribeGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeGroups"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the specified notification subscriptions.
     */
    override suspend fun describeNotificationSubscriptions(input: DescribeNotificationSubscriptionsRequest): DescribeNotificationSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeNotificationSubscriptionsRequest, DescribeNotificationSubscriptionsResponse> {
            serializer = DescribeNotificationSubscriptionsOperationSerializer()
            deserializer = DescribeNotificationSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeNotificationSubscriptions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeNotificationSubscriptions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the permissions of a specified resource.
     */
    override suspend fun describeResourcePermissions(input: DescribeResourcePermissionsRequest): DescribeResourcePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeResourcePermissionsRequest, DescribeResourcePermissionsResponse> {
            serializer = DescribeResourcePermissionsOperationSerializer()
            deserializer = DescribeResourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeResourcePermissions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeResourcePermissions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the current user's special folders; the `RootFolder` and the `RecycleBin`. `RootFolder` is the root of user's files and folders and `RecycleBin` is the root of recycled items. This is not a valid action for SigV4 (administrative API) clients.
     *
     * This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see [Authentication and Access Control for User Applications](https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html) in the *Amazon WorkDocs Developer Guide*.
     */
    override suspend fun describeRootFolders(input: DescribeRootFoldersRequest): DescribeRootFoldersResponse {
        val op = SdkHttpOperation.build<DescribeRootFoldersRequest, DescribeRootFoldersResponse> {
            serializer = DescribeRootFoldersOperationSerializer()
            deserializer = DescribeRootFoldersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeRootFolders"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRootFolders-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified users. You can describe all users or filter the results (for example, by status or organization).
     *
     * By default, Amazon WorkDocs returns the first 24 active or pending users. If there are more results, the response includes a marker that you can use to request the next set of results.
     */
    override suspend fun describeUsers(input: DescribeUsersRequest): DescribeUsersResponse {
        val op = SdkHttpOperation.build<DescribeUsersRequest, DescribeUsersResponse> {
            serializer = DescribeUsersOperationSerializer()
            deserializer = DescribeUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeUsers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeUsers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves details of the current user for whom the authentication token was generated. This is not a valid action for SigV4 (administrative API) clients.
     *
     * This action requires an authentication token. To get an authentication token, register an application with Amazon WorkDocs. For more information, see [Authentication and Access Control for User Applications](https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html) in the *Amazon WorkDocs Developer Guide*.
     */
    override suspend fun getCurrentUser(input: GetCurrentUserRequest): GetCurrentUserResponse {
        val op = SdkHttpOperation.build<GetCurrentUserRequest, GetCurrentUserResponse> {
            serializer = GetCurrentUserOperationSerializer()
            deserializer = GetCurrentUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetCurrentUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCurrentUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves details of a document.
     */
    override suspend fun getDocument(input: GetDocumentRequest): GetDocumentResponse {
        val op = SdkHttpOperation.build<GetDocumentRequest, GetDocumentResponse> {
            serializer = GetDocumentOperationSerializer()
            deserializer = GetDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetDocument"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDocument-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the requested document.
     *
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested document and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the names of the parent folders.
     */
    override suspend fun getDocumentPath(input: GetDocumentPathRequest): GetDocumentPathResponse {
        val op = SdkHttpOperation.build<GetDocumentPathRequest, GetDocumentPathResponse> {
            serializer = GetDocumentPathOperationSerializer()
            deserializer = GetDocumentPathOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetDocumentPath"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDocumentPath-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves version metadata for the specified document.
     */
    override suspend fun getDocumentVersion(input: GetDocumentVersionRequest): GetDocumentVersionResponse {
        val op = SdkHttpOperation.build<GetDocumentVersionRequest, GetDocumentVersionResponse> {
            serializer = GetDocumentVersionOperationSerializer()
            deserializer = GetDocumentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetDocumentVersion"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDocumentVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the metadata of the specified folder.
     */
    override suspend fun getFolder(input: GetFolderRequest): GetFolderResponse {
        val op = SdkHttpOperation.build<GetFolderRequest, GetFolderResponse> {
            serializer = GetFolderOperationSerializer()
            deserializer = GetFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFolder"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFolder-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the path information (the hierarchy from the root folder) for the specified folder.
     *
     * By default, Amazon WorkDocs returns a maximum of 100 levels upwards from the requested folder and only includes the IDs of the parent folders in the path. You can limit the maximum number of levels. You can also request the parent folder names.
     */
    override suspend fun getFolderPath(input: GetFolderPathRequest): GetFolderPathResponse {
        val op = SdkHttpOperation.build<GetFolderPathRequest, GetFolderPathResponse> {
            serializer = GetFolderPathOperationSerializer()
            deserializer = GetFolderPathOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFolderPath"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFolderPath-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a collection of resources, including folders and documents. The only `CollectionType` supported is `SHARED_WITH_ME`.
     */
    override suspend fun getResources(input: GetResourcesRequest): GetResourcesResponse {
        val op = SdkHttpOperation.build<GetResourcesRequest, GetResourcesResponse> {
            serializer = GetResourcesOperationSerializer()
            deserializer = GetResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetResources"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetResources-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new document object and version object.
     *
     * The client specifies the parent folder ID and name of the document to upload. The ID is optionally specified when creating a new version of an existing document. This is the first step to upload a document. Next, upload the document to the URL returned from the call, and then call UpdateDocumentVersion.
     *
     * To cancel the document upload, call AbortDocumentVersionUpload.
     */
    override suspend fun initiateDocumentVersionUpload(input: InitiateDocumentVersionUploadRequest): InitiateDocumentVersionUploadResponse {
        val op = SdkHttpOperation.build<InitiateDocumentVersionUploadRequest, InitiateDocumentVersionUploadResponse> {
            serializer = InitiateDocumentVersionUploadOperationSerializer()
            deserializer = InitiateDocumentVersionUploadOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "InitiateDocumentVersionUpload"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("InitiateDocumentVersionUpload-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes all the permissions from the specified resource.
     */
    override suspend fun removeAllResourcePermissions(input: RemoveAllResourcePermissionsRequest): RemoveAllResourcePermissionsResponse {
        val op = SdkHttpOperation.build<RemoveAllResourcePermissionsRequest, RemoveAllResourcePermissionsResponse> {
            serializer = RemoveAllResourcePermissionsOperationSerializer()
            deserializer = RemoveAllResourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "RemoveAllResourcePermissions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveAllResourcePermissions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the permission for the specified principal from the specified resource.
     */
    override suspend fun removeResourcePermission(input: RemoveResourcePermissionRequest): RemoveResourcePermissionResponse {
        val op = SdkHttpOperation.build<RemoveResourcePermissionRequest, RemoveResourcePermissionResponse> {
            serializer = RemoveResourcePermissionOperationSerializer()
            deserializer = RemoveResourcePermissionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "RemoveResourcePermission"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveResourcePermission-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Recovers a deleted version of an Amazon WorkDocs document.
     */
    override suspend fun restoreDocumentVersions(input: RestoreDocumentVersionsRequest): RestoreDocumentVersionsResponse {
        val op = SdkHttpOperation.build<RestoreDocumentVersionsRequest, RestoreDocumentVersionsResponse> {
            serializer = RestoreDocumentVersionsOperationSerializer()
            deserializer = RestoreDocumentVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "RestoreDocumentVersions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RestoreDocumentVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Searches metadata and the content of folders, documents, document versions, and comments.
     */
    override suspend fun searchResources(input: SearchResourcesRequest): SearchResourcesResponse {
        val op = SdkHttpOperation.build<SearchResourcesRequest, SearchResourcesResponse> {
            serializer = SearchResourcesOperationSerializer()
            deserializer = SearchResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchResources"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchResources-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified attributes of a document. The user must have access to both the document and its parent folder, if applicable.
     */
    override suspend fun updateDocument(input: UpdateDocumentRequest): UpdateDocumentResponse {
        val op = SdkHttpOperation.build<UpdateDocumentRequest, UpdateDocumentResponse> {
            serializer = UpdateDocumentOperationSerializer()
            deserializer = UpdateDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateDocument"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDocument-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes the status of the document version to ACTIVE.
     *
     * Amazon WorkDocs also sets its document container to ACTIVE. This is the last step in a document upload, after the client uploads the document to an S3-presigned URL returned by InitiateDocumentVersionUpload.
     */
    override suspend fun updateDocumentVersion(input: UpdateDocumentVersionRequest): UpdateDocumentVersionResponse {
        val op = SdkHttpOperation.build<UpdateDocumentVersionRequest, UpdateDocumentVersionResponse> {
            serializer = UpdateDocumentVersionOperationSerializer()
            deserializer = UpdateDocumentVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateDocumentVersion"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDocumentVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified attributes of the specified folder. The user must have access to both the folder and its parent folder, if applicable.
     */
    override suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse {
        val op = SdkHttpOperation.build<UpdateFolderRequest, UpdateFolderResponse> {
            serializer = UpdateFolderOperationSerializer()
            deserializer = UpdateFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateFolder"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFolder-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializer = UpdateUserOperationSerializer()
            deserializer = UpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "workdocs")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
