// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.transform

import aws.sdk.kotlin.services.wellarchitected.model.AnswerReason
import aws.sdk.kotlin.services.wellarchitected.model.ChoiceUpdate
import aws.sdk.kotlin.services.wellarchitected.model.UpdateAnswerRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAnswerOperationSerializer: HttpSerialize<UpdateAnswerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAnswerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "workloads",
                "${input.workloadId}".encodeLabel(),
                "lensReviews",
                "${input.lensAlias}".encodeLabel(),
                "answers",
                "${input.questionId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateAnswerOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAnswerOperationBody(context: ExecutionContext, input: UpdateAnswerRequest): ByteArray {
    val serializer = JsonSerializer()
    val CHOICEUPDATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ChoiceUpdates"))
    val ISAPPLICABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsApplicable"))
    val NOTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Notes"))
    val REASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Reason"))
    val SELECTEDCHOICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SelectedChoices"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHOICEUPDATES_DESCRIPTOR)
        field(ISAPPLICABLE_DESCRIPTOR)
        field(NOTES_DESCRIPTOR)
        field(REASON_DESCRIPTOR)
        field(SELECTEDCHOICES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.choiceUpdates != null) {
            mapField(CHOICEUPDATES_DESCRIPTOR) {
                input.choiceUpdates.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeChoiceUpdateDocument)) }
            }
        }
        if (input.isApplicable != false) field(ISAPPLICABLE_DESCRIPTOR, input.isApplicable)
        input.notes?.let { field(NOTES_DESCRIPTOR, it) }
        input.reason?.let { field(REASON_DESCRIPTOR, it.value) }
        if (input.selectedChoices != null) {
            listField(SELECTEDCHOICES_DESCRIPTOR) {
                for (el0 in input.selectedChoices) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
