// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.transform

import aws.sdk.kotlin.services.wellarchitected.model.ListCheckDetailsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListCheckDetailsOperationSerializer: HttpSerialize<ListCheckDetailsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListCheckDetailsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "workloads",
                "${input.workloadId}".encodeLabel(),
                "checks",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeListCheckDetailsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListCheckDetailsOperationBody(context: ExecutionContext, input: ListCheckDetailsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CHOICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChoiceId"))
    val LENSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensArn"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PILLARID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PillarId"))
    val QUESTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QuestionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHOICEID_DESCRIPTOR)
        field(LENSARN_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PILLARID_DESCRIPTOR)
        field(QUESTIONID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.choiceId?.let { field(CHOICEID_DESCRIPTOR, it) }
        input.lensArn?.let { field(LENSARN_DESCRIPTOR, it) }
        if (input.maxResults != 0) field(MAXRESULTS_DESCRIPTOR, input.maxResults)
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.pillarId?.let { field(PILLARID_DESCRIPTOR, it) }
        input.questionId?.let { field(QUESTIONID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
