// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wellarchitected.model.ImportLensResponse
import aws.sdk.kotlin.services.wellarchitected.model.ImportLensStatus
import aws.sdk.kotlin.services.wellarchitected.model.WellArchitectedException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportLensOperationDeserializer: HttpDeserialize<ImportLensResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ImportLensResponse {
        if (!response.status.isSuccess()) {
            throwImportLensError(context, response)
        }
        val builder = ImportLensResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeImportLensOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwImportLensError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WellArchitectedException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WellArchitectedException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeImportLensOperationBody(builder: ImportLensResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LENSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LENSARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LENSARN_DESCRIPTOR.index -> builder.lensArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ImportLensStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
