// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wellarchitected.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wellarchitected.model.GetLensVersionDifferenceResponse
import aws.sdk.kotlin.services.wellarchitected.model.VersionDifferences
import aws.sdk.kotlin.services.wellarchitected.model.WellArchitectedException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetLensVersionDifferenceOperationDeserializer: HttpDeserialize<GetLensVersionDifferenceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLensVersionDifferenceResponse {
        if (!response.status.isSuccess()) {
            throwGetLensVersionDifferenceError(context, response)
        }
        val builder = GetLensVersionDifferenceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLensVersionDifferenceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLensVersionDifferenceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WellArchitectedException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WellArchitectedException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLensVersionDifferenceOperationBody(builder: GetLensVersionDifferenceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASELENSVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaseLensVersion"))
    val LATESTLENSVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestLensVersion"))
    val LENSALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensAlias"))
    val LENSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LensArn"))
    val TARGETLENSVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetLensVersion"))
    val VERSIONDIFFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VersionDifferences"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASELENSVERSION_DESCRIPTOR)
        field(LATESTLENSVERSION_DESCRIPTOR)
        field(LENSALIAS_DESCRIPTOR)
        field(LENSARN_DESCRIPTOR)
        field(TARGETLENSVERSION_DESCRIPTOR)
        field(VERSIONDIFFERENCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASELENSVERSION_DESCRIPTOR.index -> builder.baseLensVersion = deserializeString()
                LATESTLENSVERSION_DESCRIPTOR.index -> builder.latestLensVersion = deserializeString()
                LENSALIAS_DESCRIPTOR.index -> builder.lensAlias = deserializeString()
                LENSARN_DESCRIPTOR.index -> builder.lensArn = deserializeString()
                TARGETLENSVERSION_DESCRIPTOR.index -> builder.targetLensVersion = deserializeString()
                VERSIONDIFFERENCES_DESCRIPTOR.index -> builder.versionDifferences = deserializeVersionDifferencesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
